/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class INVERSEMAP
extends EvalFunc<Map> {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();

    @Override
    public Map exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        Map inputMap = (Map)input.get(0);
        if (inputMap == null) {
            return null;
        }
        return this.doInverse(inputMap);
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            if (input.getField((int)0).type != 100) {
                throw new RuntimeException("Expected map, received schema " + DataType.findTypeName(input.getField((int)0).type));
            }
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
        return new Schema(new Schema.FieldSchema(null, 100));
    }

    private HashMap<String, DataBag> doInverse(Map<String, Object> original) throws ExecException {
        HashMap<String, DataBag> inverseMap = new HashMap<String, DataBag>(original.size());
        for (Map.Entry<String, Object> entry : original.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof Tuple || o instanceof DataBag) {
                throw new ExecException("Wrong type. Value is of type " + o.getClass());
            }
            String newKey = o.toString();
            DataBag bag = inverseMap.get(newKey);
            if (bag == null) {
                bag = new NonSpillableDataBag();
                bag.add(TUPLE_FACTORY.newTuple(entry.getKey()));
                inverseMap.put(newKey, bag);
                continue;
            }
            bag.add(TUPLE_FACTORY.newTuple(entry.getKey()));
        }
        return inverseMap;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

