/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationBarrierCleaner
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationBarrierCleaner.class);
    private static final String REPLICATION_BARRIER_CLEANER_INTERVAL = "hbase.master.cleaner.replication.barrier.interval";
    private static final int DEFAULT_REPLICATION_BARRIER_CLEANER_INTERVAL = 43200000;
    private final Connection conn;
    private final ReplicationPeerManager peerManager;

    public ReplicationBarrierCleaner(Configuration conf, Stoppable stopper, Connection conn, ReplicationPeerManager peerManager) {
        super("ReplicationBarrierCleaner", stopper, conf.getInt(REPLICATION_BARRIER_CLEANER_INTERVAL, 43200000));
        this.conn = conn;
        this.peerManager = peerManager;
    }

    public synchronized void chore() {
        long totalRows = 0L;
        long cleanedRows = 0L;
        long deletedRows = 0L;
        long deletedBarriers = 0L;
        long deletedLastPushedSeqIds = 0L;
        TableName tableName = null;
        List<String> peerIds = null;
        try (Table metaTable = this.conn.getTable(TableName.META_TABLE_NAME);
             ResultScanner scanner = metaTable.getScanner(new Scan().addFamily(HConstants.REPLICATION_BARRIER_FAMILY).readAllVersions());){
            Result result;
            while ((result = scanner.next()) != null) {
                ++totalRows;
                long[] barriers = MetaTableAccessor.getReplicationBarriers((Result)result);
                if (barriers.length == 0) continue;
                byte[] regionName = result.getRow();
                TableName tn = RegionInfo.getTable((byte[])regionName);
                if (!tn.equals(tableName)) {
                    tableName = tn;
                    peerIds = this.peerManager.getSerialPeerIdsBelongsTo(tableName);
                }
                if (peerIds.isEmpty()) {
                    if (metaTable.exists(new Get(regionName).addFamily(HConstants.CATALOG_FAMILY))) {
                        Cell cell = result.getColumnLatestCell(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER);
                        metaTable.delete(new Delete(regionName).addFamily(HConstants.REPLICATION_BARRIER_FAMILY, cell.getTimestamp() - 1L));
                        deletedBarriers += (long)(barriers.length - 1);
                    } else {
                        metaTable.delete(new Delete(regionName).addFamily(HConstants.REPLICATION_BARRIER_FAMILY));
                        deletedBarriers += (long)barriers.length;
                    }
                    ++cleanedRows;
                    continue;
                }
                String encodedRegionName = RegionInfo.encodeRegionName((byte[])regionName);
                long pushedSeqId = Long.MAX_VALUE;
                for (String peerId : peerIds) {
                    pushedSeqId = Math.min(pushedSeqId, this.peerManager.getQueueStorage().getLastSequenceId(encodedRegionName, peerId));
                }
                int index = Arrays.binarySearch(barriers, pushedSeqId);
                if (index == -1) continue;
                index = index < 0 ? -index - 1 : ++index;
                if (index == barriers.length - 1 && pushedSeqId == barriers[barriers.length - 1] - 1L && !metaTable.exists(new Get(regionName).addFamily(HConstants.CATALOG_FAMILY))) {
                    ReplicationQueueStorage queueStorage = this.peerManager.getQueueStorage();
                    for (String peerId : peerIds) {
                        queueStorage.removeLastSequenceIds(peerId, Arrays.asList(encodedRegionName));
                        ++deletedLastPushedSeqIds;
                    }
                    metaTable.delete(new Delete(regionName).addFamily(HConstants.REPLICATION_BARRIER_FAMILY));
                    ++deletedRows;
                    deletedBarriers += (long)barriers.length;
                    continue;
                }
                if (index - 1 <= 0) continue;
                List cells = result.getColumnCells(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER);
                Cell cell = (Cell)cells.get(cells.size() - index);
                metaTable.delete(new Delete(regionName).addFamily(HConstants.REPLICATION_BARRIER_FAMILY, cell.getTimestamp() - 1L));
                ++cleanedRows;
                deletedBarriers += (long)(index - 1);
            }
        }
        catch (IOException | ReplicationException e) {
            LOG.warn("Failed to clean up replication barrier", e);
        }
        if (totalRows > 0L) {
            LOG.info("TotalRows={}, cleanedRows={}, deletedRows={}, deletedBarriers={}, deletedLastPushedSeqIds={}", new Object[]{totalRows, cleanedRows, deletedRows, deletedBarriers, deletedLastPushedSeqIds});
        }
    }
}

