/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import org.apache.hadoop.util.VersionInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class VersionUtils$ {
    public static VersionUtils$ MODULE$;
    private final Regex majorMinorRegex;
    private final Regex shortVersionRegex;
    private final Regex majorMinorPatchRegex;

    static {
        new VersionUtils$();
    }

    private Regex majorMinorRegex() {
        return this.majorMinorRegex;
    }

    private Regex shortVersionRegex() {
        return this.shortVersionRegex;
    }

    private Regex majorMinorPatchRegex() {
        return this.majorMinorPatchRegex;
    }

    public boolean isHadoop3() {
        return this.majorVersion(VersionInfo.getVersion()) == 3;
    }

    public int majorVersion(String sparkVersion) {
        return this.majorMinorVersion(sparkVersion)._1$mcI$sp();
    }

    public int minorVersion(String sparkVersion) {
        return this.majorMinorVersion(sparkVersion)._2$mcI$sp();
    }

    public String shortVersion(String sparkVersion) {
        Option option = this.shortVersionRegex().findFirstMatchIn((CharSequence)sparkVersion);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return m.group(1);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(117).append("Spark tried to parse '").append(sparkVersion).append("' as a Spark").append(" version string, but it could not find the major/minor/maintenance version numbers.").toString());
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<Object, Object> majorMinorVersion(String sparkVersion) {
        Option option = this.majorMinorRegex().findFirstMatchIn((CharSequence)sparkVersion);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt(), new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt());
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(109).append("Spark tried to parse '").append(sparkVersion).append("' as a Spark").append(" version string, but it could not find the major and minor version numbers.").toString());
        }
        throw new MatchError((Object)option);
    }

    public Option<Tuple3<Object, Object, Object>> majorMinorPatchVersion(String version) {
        return this.majorMinorPatchRegex().findFirstMatchIn((CharSequence)version).map((Function1 & Serializable & scala.Serializable)m -> {
            int major = new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt();
            int minor = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)m.group(2)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)VersionUtils$.$anonfun$majorMinorPatchVersion$2(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int patch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)m.group(3)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)VersionUtils$.$anonfun$majorMinorPatchVersion$4(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)major), (Object)BoxesRunTime.boxToInteger((int)minor), (Object)BoxesRunTime.boxToInteger((int)patch));
        });
    }

    public static final /* synthetic */ int $anonfun$majorMinorPatchVersion$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ int $anonfun$majorMinorPatchVersion$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    private VersionUtils$() {
        MODULE$ = this;
        this.majorMinorRegex = new StringOps(Predef$.MODULE$.augmentString("^(\\d+)\\.(\\d+)(\\..*)?$")).r();
        this.shortVersionRegex = new StringOps(Predef$.MODULE$.augmentString("^(\\d+\\.\\d+\\.\\d+)(.*)?$")).r();
        this.majorMinorPatchRegex = new StringOps(Predef$.MODULE$.augmentString("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:[.-].*)?)?)?$")).r();
    }
}

