/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.util;

import com.google.inject.Provider;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.util.ConfigurationProvider;
import org.apache.tephra.util.HBaseVersionSpecificFactory;

public class ConfigurationFactory
implements Provider<Configuration> {
    private final ConfigurationProvider provider = (ConfigurationProvider)new ConfigurationProviderFactory().get();

    public Configuration get() {
        return this.provider.get();
    }

    public Configuration get(Configuration baseConf) {
        return this.provider.get(baseConf);
    }

    private static class ConfigurationProviderFactory
    extends HBaseVersionSpecificFactory<ConfigurationProvider> {
        private ConfigurationProviderFactory() {
        }

        @Override
        protected String getHBase96Classname() {
            return "org.apache.tephra.hbase.HBase96ConfigurationProvider";
        }

        @Override
        protected String getHBase98Classname() {
            return "org.apache.tephra.hbase.HBase98ConfigurationProvider";
        }

        @Override
        protected String getHBase10Classname() {
            return "org.apache.tephra.hbase.HBase10ConfigurationProvider";
        }

        @Override
        protected String getHBase11Classname() {
            return "org.apache.tephra.hbase.HBase11ConfigurationProvider";
        }

        @Override
        protected String getHBase13Classname() {
            return "org.apache.tephra.hbase.HBase13ConfigurationProvider";
        }

        @Override
        protected String getHBase20Classname() {
            return "org.apache.tephra.hbase.HBase20ConfigurationProvider";
        }

        @Override
        protected String getHBase10CDHClassname() {
            return "org.apache.tephra.hbase.HBase10ConfigurationProvider";
        }

        @Override
        protected String getHBase14Classname() {
            return "org.apache.tephra.hbase.HBase14ConfigurationProvider";
        }

        @Override
        protected String getHBase23Classname() {
            return "org.apache.tephra.hbase.HBase23ConfigurationProvider";
        }
    }
}

