/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnNameTrackingExpressionCompiler;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.TableInfo;
import org.apache.phoenix.coprocessor.WhereConstantParser;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewUtil {
    private static final Logger logger = LoggerFactory.getLogger(ViewUtil.class);

    public static Pair<List<PTable>, List<TableInfo>> findAllDescendantViews(Table sysCatOrsysChildLink, Configuration serverSideConfig, byte[] tenantId, byte[] schemaName, byte[] tableOrViewName, long clientTimeStamp, boolean findJustOneLegitimateChildView) throws IOException, SQLException {
        ArrayList<PTable> legitimateChildViews = new ArrayList<PTable>();
        ArrayList<TableInfo> orphanChildViews = new ArrayList<TableInfo>();
        ViewUtil.findAllDescendantViews(sysCatOrsysChildLink, serverSideConfig, tenantId, schemaName, tableOrViewName, clientTimeStamp, legitimateChildViews, orphanChildViews, findJustOneLegitimateChildView);
        return new Pair(legitimateChildViews, orphanChildViews);
    }

    private static void findAllDescendantViews(Table sysCatOrsysChildLink, Configuration serverSideConfig, byte[] parentTenantId, byte[] parentSchemaName, byte[] parentTableOrViewName, long clientTimeStamp, List<PTable> legitimateChildViews, List<TableInfo> orphanChildViews, boolean findJustOneLegitimateChildView) throws IOException, SQLException {
        TableViewFinderResult currentResult = ViewUtil.findImmediateRelatedViews(sysCatOrsysChildLink, parentTenantId, parentSchemaName, parentTableOrViewName, PTable.LinkType.CHILD_TABLE, clientTimeStamp);
        for (TableInfo viewInfo : currentResult.getLinks()) {
            PTable view;
            byte[] viewTenantId = viewInfo.getTenantId();
            byte[] viewSchemaName = viewInfo.getSchemaName();
            byte[] viewName = viewInfo.getTableName();
            Properties props = new Properties();
            if (viewTenantId != null) {
                props.setProperty("TenantId", Bytes.toString((byte[])viewTenantId));
            }
            if (clientTimeStamp != Long.MAX_VALUE) {
                props.setProperty("CurrentSCN", Long.toString(clientTimeStamp));
            }
            PhoenixConnection connection = QueryUtil.getConnectionOnServer(props, serverSideConfig).unwrap(PhoenixConnection.class);
            Throwable throwable = null;
            try {
                view = PhoenixRuntime.getTableNoCache(connection, SchemaUtil.getTableName(viewSchemaName, viewName));
            }
            catch (TableNotFoundException ex) {
                logger.error("Found an orphan parent->child link keyed by this parent. Parent Tenant Id: '" + Bytes.toString((byte[])parentTenantId) + "'. Parent Schema Name: '" + Bytes.toString((byte[])parentSchemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])parentTableOrViewName) + "'. The child view which could not be resolved has ViewInfo: '" + viewInfo + "'.", (Throwable)ex);
                orphanChildViews.add(viewInfo);
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                connection.close();
                continue;
            }
            try {
                if (ViewUtil.isLegitimateChildView(view, parentSchemaName, parentTableOrViewName)) {
                    legitimateChildViews.add(view);
                    if (findJustOneLegitimateChildView) break;
                    ViewUtil.findAllDescendantViews(sysCatOrsysChildLink, serverSideConfig, viewInfo.getTenantId(), viewInfo.getSchemaName(), viewInfo.getTableName(), clientTimeStamp, legitimateChildViews, orphanChildViews, findJustOneLegitimateChildView);
                    continue;
                }
                logger.error("Found an orphan parent->child link keyed by this parent. Parent Tenant Id: '" + Bytes.toString((byte[])parentTenantId) + "'. Parent Schema Name: '" + Bytes.toString((byte[])parentSchemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])parentTableOrViewName) + "'. There currently exists a legitimate view of the same name which is not a descendant of this table/view. View Info: '" + viewInfo + "'. Ignoring this view and not counting it as a child view.");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                connection.close();
            }
        }
    }

    private static boolean isLegitimateChildView(PTable view, byte[] parentSchemaName, byte[] parentTableOrViewName) {
        return view != null && view.getParentSchemaName() != null && view.getParentTableName() != null && Arrays.equals(view.getParentSchemaName().getBytes(), parentSchemaName) && Arrays.equals(view.getParentTableName().getBytes(), parentTableOrViewName);
    }

    public static void findAllRelatives(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schema, byte[] table, PTable.LinkType linkType, TableViewFinderResult result) throws IOException {
        ViewUtil.findAllRelatives(sysCatOrsysChildLink, tenantId, schema, table, linkType, Long.MAX_VALUE, result);
    }

    private static void findAllRelatives(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schema, byte[] table, PTable.LinkType linkType, long timestamp, TableViewFinderResult result) throws IOException {
        TableViewFinderResult currentResult = ViewUtil.findImmediateRelatedViews(sysCatOrsysChildLink, tenantId, schema, table, linkType, timestamp);
        result.addResult(currentResult);
        for (TableInfo viewInfo : currentResult.getLinks()) {
            ViewUtil.findAllRelatives(sysCatOrsysChildLink, viewInfo.getTenantId(), viewInfo.getSchemaName(), viewInfo.getTableName(), linkType, timestamp, result);
        }
    }

    private static TableViewFinderResult findImmediateRelatedViews(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schema, byte[] table, PTable.LinkType linkType, long timestamp) throws IOException {
        if (linkType == PTable.LinkType.INDEX_TABLE || linkType == PTable.LinkType.EXCLUDED_COLUMN) {
            throw new IllegalArgumentException("findAllRelatives does not support link type " + (Object)((Object)linkType));
        }
        byte[] key = SchemaUtil.getTableKey(tenantId, schema, table);
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, timestamp);
        SingleColumnValueFilter linkFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareFilter.CompareOp.EQUAL, linkType.getSerializedValueAsByteArray());
        linkFilter.setFilterIfMissing(true);
        scan.setFilter((Filter)linkFilter);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        if (linkType == PTable.LinkType.PARENT_TABLE) {
            scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PARENT_TENANT_ID_BYTES);
        }
        if (linkType == PTable.LinkType.PHYSICAL_TABLE) {
            scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
        }
        ArrayList tableInfoList = Lists.newArrayList();
        try (ResultScanner scanner = sysCatOrsysChildLink.getScanner(scan);){
            Result result = scanner.next();
            while (result != null) {
                block23: {
                    byte[] viewTenantId;
                    byte[][] rowKeyMetaData;
                    block20: {
                        block22: {
                            block21: {
                                block19: {
                                    rowKeyMetaData = new byte[5][];
                                    viewTenantId = null;
                                    SchemaUtil.getVarChars(result.getRow(), 5, rowKeyMetaData);
                                    if (linkType != PTable.LinkType.PARENT_TABLE) break block19;
                                    viewTenantId = result.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PARENT_TENANT_ID_BYTES);
                                    break block20;
                                }
                                if (linkType != PTable.LinkType.CHILD_TABLE) break block21;
                                viewTenantId = rowKeyMetaData[3];
                                break block20;
                            }
                            if (linkType != PTable.LinkType.VIEW_INDEX_PARENT_TABLE) break block22;
                            viewTenantId = rowKeyMetaData[0];
                            break block20;
                        }
                        if (linkType == PTable.LinkType.PHYSICAL_TABLE && result.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES) != null) break block23;
                    }
                    byte[] viewSchemaName = SchemaUtil.getSchemaNameFromFullName(rowKeyMetaData[4]).getBytes();
                    byte[] viewName = SchemaUtil.getTableNameFromFullName(rowKeyMetaData[4]).getBytes();
                    tableInfoList.add(new TableInfo(viewTenantId, viewSchemaName, viewName));
                }
                result = scanner.next();
            }
            TableViewFinderResult tableViewFinderResult = new TableViewFinderResult(tableInfoList);
            return tableViewFinderResult;
        }
    }

    public static boolean hasChildViews(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schemaName, byte[] tableName, long timestamp) throws IOException {
        byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, timestamp);
        SingleColumnValueFilter linkFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareFilter.CompareOp.EQUAL, PTable.LinkType.CHILD_TABLE.getSerializedValueAsByteArray()){

            public boolean filterAllRemaining() {
                return this.matchedColumn;
            }
        };
        linkFilter.setFilterIfMissing(true);
        scan.setFilter((Filter)linkFilter);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        try (ResultScanner scanner = sysCatOrsysChildLink.getScanner(scan);){
            Result result = scanner.next();
            boolean bl = result != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropChildViews(RegionCoprocessorEnvironment env, byte[] tenantIdBytes, byte[] schemaName, byte[] tableOrViewName, byte[] sysCatOrSysChildLink) throws IOException, SQLException {
        TableViewFinderResult childViewsResult;
        HTableInterface hTable = null;
        try {
            hTable = ServerUtil.getHTableForCoprocessorScan(env, sysCatOrSysChildLink);
        }
        catch (Exception e) {
            logger.error("ServerUtil.getHTableForCoprocessorScan error!", (Throwable)e);
        }
        if (hTable == null) {
            return;
        }
        try {
            childViewsResult = ViewUtil.findImmediateRelatedViews((Table)hTable, tenantIdBytes, schemaName, tableOrViewName, PTable.LinkType.CHILD_TABLE, Long.MAX_VALUE);
        }
        finally {
            hTable.close();
        }
        for (TableInfo viewInfo : childViewsResult.getLinks()) {
            byte[] viewTenantId = viewInfo.getTenantId();
            byte[] viewSchemaName = viewInfo.getSchemaName();
            byte[] viewName = viewInfo.getTableName();
            if (logger.isDebugEnabled()) {
                logger.debug("dropChildViews : " + Bytes.toString((byte[])schemaName) + "." + Bytes.toString((byte[])tableOrViewName) + " -> " + Bytes.toString((byte[])viewSchemaName) + "." + Bytes.toString((byte[])viewName) + "with tenant id :" + Bytes.toString((byte[])viewTenantId));
            }
            Properties props = new Properties();
            PTable view = null;
            if (viewTenantId != null && viewTenantId.length != 0) {
                props.setProperty("TenantId", Bytes.toString((byte[])viewTenantId));
            }
            PhoenixConnection connection = QueryUtil.getConnectionOnServer(props, env.getConfiguration()).unwrap(PhoenixConnection.class);
            Throwable throwable = null;
            try {
                try {
                    view = PhoenixRuntime.getTableNoCache(connection, SchemaUtil.getTableName(viewSchemaName, viewName));
                }
                catch (TableNotFoundException expected) {
                    logger.info("Found an expected orphan parent->child link keyed by the parent. Parent Tenant Id: '" + Bytes.toString((byte[])tenantIdBytes) + "'. Parent Schema Name: '" + Bytes.toString((byte[])schemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])tableOrViewName) + "'. Will attempt to drop this child view with ViewInfo: '" + viewInfo + "'.");
                }
                if (view != null) {
                    logger.error("Found an orphan parent->child link keyed by this parent or its descendant. Parent Tenant Id: '" + Bytes.toString((byte[])tenantIdBytes) + "'. Parent Schema Name: '" + Bytes.toString((byte[])schemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])tableOrViewName) + "'. There currently exists a legitimate view of the same name whose parent hierarchy exists. View Info: '" + viewInfo + "'. Ignoring this view and not attempting to drop it.");
                    continue;
                }
                MetaDataClient client = new MetaDataClient(connection);
                org.apache.phoenix.parse.TableName viewTableName = org.apache.phoenix.parse.TableName.create(Bytes.toString((byte[])viewSchemaName), Bytes.toString((byte[])viewName));
                try {
                    client.dropTable(new DropTableStatement(viewTableName, PTableType.VIEW, true, true, true));
                }
                catch (TableNotFoundException e) {
                    logger.info("Ignoring view " + viewTableName + " as it has already been dropped");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable expected) {
                        throwable.addSuppressed(expected);
                    }
                    continue;
                }
                connection.close();
            }
        }
    }

    public static TableName getSystemTableForChildLinks(int clientVersion, Configuration conf) throws SQLException, IOException {
        byte[] fullTableName = PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES;
        if (clientVersion < MetaDataProtocol.MIN_SPLITTABLE_SYSTEM_CATALOG) {
            try (PhoenixConnection connection = QueryUtil.getConnectionOnServer(conf).unwrap(PhoenixConnection.class);){
                PhoenixRuntime.getTableNoCache(connection, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
            }
            catch (TableNotFoundException e) {
                fullTableName = PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES;
            }
            catch (SQLException e) {
                logger.error("Error getting a connection on the server : " + e);
                throw e;
            }
        }
        return SchemaUtil.getPhysicalTableName(fullTableName, conf);
    }

    public static boolean isDivergedView(PTable view) {
        return view.getBaseColumnCount() == -100;
    }

    public static boolean isViewDiverging(PColumn columnToDelete, PTable view, long clientVersion) {
        return !ViewUtil.isDivergedView(view) && (clientVersion < (long)MetaDataProtocol.MIN_SPLITTABLE_SYSTEM_CATALOG ? columnToDelete.getPosition() < view.getBaseColumnCount() : columnToDelete.isDerived());
    }

    public static void addIndexesFromParent(PhoenixConnection connection, PTable view, PTable parentTable, List<PTable> inheritedIndexes) throws SQLException {
        List<PTable> parentTableIndexes = parentTable.getIndexes();
        for (PTable index : parentTableIndexes) {
            boolean containsAllReqdCols = true;
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(parentTable, connection);
            Set<Pair<String, String>> indexedColInfos = indexMaintainer.getIndexedColumnInfo();
            for (Pair<String, String> colInfo : indexedColInfos) {
                try {
                    String colFamily = (String)colInfo.getFirst();
                    String colName = (String)colInfo.getSecond();
                    if (colFamily == null) {
                        view.getColumnForColumnName(colName);
                        continue;
                    }
                    view.getColumnFamily(colFamily).getPColumnForColumnName(colName);
                }
                catch (ColumnNotFoundException e) {
                    containsAllReqdCols = false;
                    break;
                }
            }
            for (PColumn col : view.getColumns()) {
                if (!col.isViewReferenced() && col.getViewConstant() == null) continue;
                try {
                    String indexColumnName = IndexUtil.getIndexColumnName(col);
                    index.getColumnForColumnName(indexColumnName);
                }
                catch (ColumnNotFoundException e1) {
                    PColumn indexCol = null;
                    try {
                        String cf = col.getFamilyName() != null ? col.getFamilyName().getString() : null;
                        String colName = col.getName().getString();
                        indexCol = cf != null ? parentTable.getColumnFamily(cf).getPColumnForColumnName(colName) : parentTable.getColumnForColumnName(colName);
                    }
                    catch (ColumnNotFoundException e2) {
                        containsAllReqdCols = false;
                        break;
                    }
                    if (indexCol.getViewConstant() != null && Bytes.compareTo((byte[])indexCol.getViewConstant(), (byte[])col.getViewConstant()) == 0) continue;
                    containsAllReqdCols = false;
                    break;
                }
            }
            if (!containsAllReqdCols) continue;
            String viewStatement = IndexUtil.rewriteViewStatement(connection, index, parentTable, view.getViewStatement());
            PName modifiedIndexName = PNameFactory.newName(view.getName().getString() + "#" + index.getName().getString());
            if (Objects.equal((Object)viewStatement, (Object)index.getViewStatement())) {
                inheritedIndexes.add(index);
                continue;
            }
            inheritedIndexes.add(PTableImpl.builderWithColumns(index, PTableImpl.getColumnsToClone(index)).setTableName(modifiedIndexName).setViewStatement(viewStatement).setUpdateCacheFrequency(view.getUpdateCacheFrequency()).setTenantId(view.getTenantId()).setPhysicalNames(Collections.singletonList(index.getPhysicalName())).build());
        }
    }

    public static PTable addDerivedColumnsAndIndexesFromParent(PhoenixConnection connection, PTable table, PTable parentTable) throws SQLException {
        boolean hasIndexId;
        PTable pTable = ViewUtil.addDerivedColumnsFromParent(table, parentTable);
        boolean bl = hasIndexId = table.getViewIndexId() != null;
        if (!hasIndexId) {
            ArrayList allIndexes = Lists.newArrayList();
            if (pTable != null && pTable.getIndexes() != null && !pTable.getIndexes().isEmpty()) {
                for (PTable viewIndex : pTable.getIndexes()) {
                    PTable resolvedViewIndex = ViewUtil.addDerivedColumnsAndIndexesFromParent(connection, viewIndex, pTable);
                    if (resolvedViewIndex == null) continue;
                    allIndexes.add(resolvedViewIndex);
                }
            }
            ArrayList inheritedIndexes = Lists.newArrayList();
            ViewUtil.addIndexesFromParent(connection, pTable, parentTable, inheritedIndexes);
            allIndexes.addAll(inheritedIndexes);
            if (!allIndexes.isEmpty()) {
                pTable = PTableImpl.builderWithColumns(pTable, PTableImpl.getColumnsToClone(pTable)).setIndexes(allIndexes).build();
            }
        }
        return pTable;
    }

    public static PTable addDerivedColumnsFromParent(PTable view, PTable parentTable) throws SQLException {
        boolean isDiverged;
        boolean hasIndexId = view.getViewIndexId() != null;
        boolean isSalted = view.getBucketNum() != null;
        boolean isDivergedViewCreatedPre4_15 = isDiverged = ViewUtil.isDivergedView(view);
        ArrayList allColumns = Lists.newArrayList();
        ArrayList excludedColumns = Lists.newArrayList();
        List<PColumn> myColumns = view.getColumns();
        myColumns = myColumns.subList(isSalted ? 1 : 0, myColumns.size());
        for (int i = myColumns.size() - 1; i >= 0; --i) {
            PColumn pColumn = myColumns.get(i);
            if (pColumn.isExcluded()) {
                isDivergedViewCreatedPre4_15 = false;
                excludedColumns.add(pColumn);
            }
            allColumns.add(pColumn);
        }
        HashMap indexRequiredDroppedDataColMap = Maps.newHashMapWithExpectedSize((int)view.getColumns().size());
        if (hasIndexId) {
            int indexPosOffset = (isSalted ? 1 : 0) + (view.isMultiTenant() ? 1 : 0) + 1;
            ColumnNameTrackingExpressionCompiler expressionCompiler = new ColumnNameTrackingExpressionCompiler();
            for (int i = indexPosOffset; i < view.getPKColumns().size(); ++i) {
                PColumn indexColumn = view.getPKColumns().get(i);
                try {
                    expressionCompiler.reset();
                    String expressionStr = IndexUtil.getIndexColumnExpressionStr(indexColumn);
                    ParseNode parseNode = SQLParser.parseCondition(expressionStr);
                    parseNode.accept(expressionCompiler);
                    indexRequiredDroppedDataColMap.put(indexColumn, Lists.newArrayList(expressionCompiler.getDataColumnNames()));
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        long maxTableTimestamp = view.getTimeStamp();
        long maxDDLTimestamp = view.getLastDDLTimestamp() != null ? view.getLastDDLTimestamp() : 0L;
        int numPKCols = view.getPKColumns().size();
        maxTableTimestamp = Math.max(maxTableTimestamp, parentTable.getTimeStamp());
        maxDDLTimestamp = Math.max(maxDDLTimestamp, parentTable.getLastDDLTimestamp() != null ? parentTable.getLastDDLTimestamp() : 0L);
        if (hasIndexId) {
            int startIndex;
            for (int index = startIndex = parentTable.getBucketNum() != null ? 1 : 0; index < parentTable.getPKColumns().size(); ++index) {
                int existingColumnIndex;
                PColumn pkColumn = parentTable.getPKColumns().get(index);
                if (pkColumn.equals(SaltingUtil.SALTING_COLUMN) || pkColumn.isExcluded() || pkColumn.getViewConstant() != null || (existingColumnIndex = allColumns.indexOf(pkColumn = IndexUtil.getIndexPKColumn(++numPKCols, pkColumn))) != -1) continue;
                allColumns.add(0, pkColumn);
            }
            for (int j = 0; j < parentTable.getColumns().size(); ++j) {
                PColumn tableColumn = parentTable.getColumns().get(j);
                if (tableColumn.isExcluded()) continue;
                String dataColumnName = tableColumn.getName().getString();
                for (Map.Entry entry : indexRequiredDroppedDataColMap.entrySet()) {
                    ((List)entry.getValue()).remove(dataColumnName);
                }
            }
        } else if (!isDivergedViewCreatedPre4_15) {
            ViewUtil.inheritColumnsFromParent(view, parentTable, isDiverged, excludedColumns, allColumns);
        }
        for (Map.Entry entry : indexRequiredDroppedDataColMap.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            PColumn indexColumnToBeDropped = (PColumn)entry.getKey();
            if (SchemaUtil.isPKColumn(indexColumnToBeDropped)) {
                return null;
            }
            allColumns.remove(indexColumnToBeDropped);
        }
        ArrayList columnsToAdd = Lists.newArrayList();
        int position = isSalted ? 1 : 0;
        for (int i = allColumns.size() - 1; i >= 0; --i) {
            PColumn column = (PColumn)allColumns.get(i);
            if (view.getColumns().contains(column)) {
                columnsToAdd.add(new PColumnImpl(column, position++));
                continue;
            }
            columnsToAdd.add(new PColumnImpl(column, true, position++));
        }
        int baseTableColumnCount = isDiverged ? -100 : columnsToAdd.size() - myColumns.size() + (isSalted ? 1 : 0);
        long updateCacheFreq = view.getType() != PTableType.VIEW || view.hasViewModifiedUpdateCacheFrequency() ? view.getUpdateCacheFrequency() : parentTable.getUpdateCacheFrequency();
        Boolean useStatsForParallelization = view.getType() != PTableType.VIEW || view.hasViewModifiedUseStatsForParallelization() ? view.useStatsForParallelization() : parentTable.useStatsForParallelization();
        PTable pTable = PTableImpl.builderWithColumns(view, columnsToAdd).setImmutableRows(parentTable.isImmutableRows()).setDisableWAL(parentTable.isWALDisabled()).setMultiTenant(parentTable.isMultiTenant()).setStoreNulls(parentTable.getStoreNulls()).setTransactionProvider(parentTable.getTransactionProvider()).setAutoPartitionSeqName(parentTable.getAutoPartitionSeqName()).setAppendOnlySchema(parentTable.isAppendOnlySchema()).setBaseColumnCount(baseTableColumnCount).setTimeStamp(maxTableTimestamp).setExcludedColumns((List<PColumn>)ImmutableList.copyOf((Collection)excludedColumns)).setUpdateCacheFrequency(updateCacheFreq).setUseStatsForParallelization(useStatsForParallelization).setLastDDLTimestamp(maxDDLTimestamp).build();
        pTable = WhereConstantParser.addViewInfoToPColumnsIfNeeded(pTable);
        return pTable;
    }

    static void inheritColumnsFromParent(PTable view, PTable parentTable, boolean isDiverged, List<PColumn> excludedColumns, List<PColumn> allColumns) {
        List<PColumn> currAncestorTableCols = PTableImpl.getColumnsToClone(parentTable);
        if (currAncestorTableCols != null) {
            for (int j = currAncestorTableCols.size() - 1; j >= 0; --j) {
                int existingExcludedIndex;
                PColumn ancestorColumn = currAncestorTableCols.get(j);
                if (isDiverged && ancestorColumn.getFamilyName() != null && ancestorColumn.getTimestamp() > view.getTimeStamp() || (existingExcludedIndex = excludedColumns.indexOf(ancestorColumn)) != -1 && ancestorColumn.getTimestamp() <= excludedColumns.get(existingExcludedIndex).getTimestamp()) continue;
                if (ancestorColumn.isExcluded()) {
                    excludedColumns.add(ancestorColumn);
                    continue;
                }
                int existingColumnIndex = allColumns.indexOf(ancestorColumn);
                if (existingColumnIndex != -1) {
                    PColumn existingColumn = allColumns.get(existingColumnIndex);
                    if (!isDiverged && ancestorColumn.getTimestamp() > existingColumn.getTimestamp()) {
                        allColumns.remove(existingColumnIndex);
                        allColumns.add(new PColumnImpl(ancestorColumn, true, ancestorColumn.getPosition()));
                        continue;
                    }
                    allColumns.set(existingColumnIndex, new PColumnImpl(existingColumn, true, existingColumn.getPosition()));
                    continue;
                }
                allColumns.add(new PColumnImpl(ancestorColumn, true, ancestorColumn.getPosition()));
            }
        }
        for (PColumn excludedColumn : excludedColumns) {
            int index = allColumns.indexOf(excludedColumn);
            if (index == -1 || allColumns.get(index).getTimestamp() > excludedColumn.getTimestamp()) continue;
            allColumns.remove(excludedColumn);
        }
    }

    public static void addTagsToPutsForViewAlteredProperties(List<Mutation> tableMetaData, PTable parent) {
        byte[] parentUpdateCacheFreqBytes = null;
        byte[] parentUseStatsForParallelizationBytes = null;
        byte[] parentPhoenixTTLBytes = null;
        if (parent != null) {
            parentUpdateCacheFreqBytes = new byte[PLong.INSTANCE.getByteSize().intValue()];
            PLong.INSTANCE.getCodec().encodeLong(parent.getUpdateCacheFrequency(), parentUpdateCacheFreqBytes, 0);
            if (parent.useStatsForParallelization() != null) {
                parentUseStatsForParallelizationBytes = PBoolean.INSTANCE.toBytes(parent.useStatsForParallelization());
            }
            parentPhoenixTTLBytes = new byte[PLong.INSTANCE.getByteSize().intValue()];
            PLong.INSTANCE.getCodec().encodeLong(parent.getPhoenixTTL(), parentPhoenixTTLBytes, 0);
        }
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put)) continue;
            MetaDataUtil.conditionallyAddTagsToPutCells((Put)m, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.UPDATE_CACHE_FREQUENCY_BYTES, parentUpdateCacheFreqBytes, MetaDataEndpointImpl.VIEW_MODIFIED_PROPERTY_BYTES);
            MetaDataUtil.conditionallyAddTagsToPutCells((Put)m, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.USE_STATS_FOR_PARALLELIZATION_BYTES, parentUseStatsForParallelizationBytes, MetaDataEndpointImpl.VIEW_MODIFIED_PROPERTY_BYTES);
            MetaDataUtil.conditionallyAddTagsToPutCells((Put)m, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PHOENIX_TTL_BYTES, parentPhoenixTTLBytes, MetaDataEndpointImpl.VIEW_MODIFIED_PROPERTY_BYTES);
        }
    }
}

