/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Properties deepCopy(Properties properties) {
        Properties newProperties = new Properties();
        for (String pName : properties.stringPropertyNames()) {
            newProperties.setProperty(pName, properties.getProperty(pName));
        }
        return newProperties;
    }

    public static Properties combineProperties(Properties props, Configuration conf) {
        return PropertiesUtil.combineProperties(props, conf, Collections.emptySet());
    }

    public static Properties combineProperties(Properties props, Configuration conf, Set<String> withoutTheseProps) {
        Iterator iterator = conf.iterator();
        Properties copy = PropertiesUtil.deepCopy(props);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (copy.getProperty((String)entry.getKey()) != null || withoutTheseProps.contains(entry.getKey())) continue;
                copy.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return copy;
    }

    public static Configuration cloneConfig(Configuration toCopy) {
        Configuration clone = new Configuration();
        for (Map.Entry entry : toCopy) {
            clone.set((String)entry.getKey(), (String)entry.getValue());
        }
        return clone;
    }
}

