/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.util.concurrent.CountDownLatch;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.WorldClockOracleImpl;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestWorldTimeOracle {
    private static final Logger LOG = LoggerFactory.getLogger(TestWorldTimeOracle.class);
    @Mock
    private MetricsRegistry metrics;
    @Mock
    private Panicker panicker;
    @Mock
    private TimestampStorage timestampStorage;
    @Mock
    private TSOServerConfig config;
    @InjectMocks
    private WorldClockOracleImpl worldClockOracle;

    @BeforeMethod(alwaysRun=true, timeOut=30000L)
    public void initMocksAndComponents() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeOut=30000L)
    public void testMonotonicTimestampGrowth() throws Exception {
        this.worldClockOracle.initialize();
        long last = this.worldClockOracle.next();
        int timestampIntervalSec = 20;
        for (int i = 0; i < timestampIntervalSec; ++i) {
            long current = this.worldClockOracle.next();
            Assert.assertTrue((current > last + 1L ? 1 : 0) != 0, (String)"Timestamp should be based on world time");
            last = current;
            Thread.sleep(1000L);
        }
        Assert.assertTrue((this.worldClockOracle.getLast() == last ? 1 : 0) != 0);
        LOG.info("Last timestamp: {}", (Object)last);
    }

    @Test(timeOut=10000L)
    public void testTimestampOraclePanicsWhenTheStorageHasProblems() throws Exception {
        this.worldClockOracle.initialize();
        final CountDownLatch updateMaxTimestampMethodCalled = new CountDownLatch(1);
        ((TimestampStorage)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                updateMaxTimestampMethodCalled.countDown();
                throw new RuntimeException("Out of memory or something");
            }
        }).when((Object)this.timestampStorage)).updateMaxTimestamp(Matchers.anyLong(), Matchers.anyLong());
        Thread allocThread = new Thread("AllocThread"){

            @Override
            public void run() {
                while (true) {
                    TestWorldTimeOracle.this.worldClockOracle.next();
                }
            }
        };
        allocThread.start();
        updateMaxTimestampMethodCalled.await();
        ((Panicker)Mockito.verify((Object)this.panicker, (VerificationMode)Mockito.atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
    }
}

