/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result.impl;

import java.io.IOException;
import org.apache.commons.csv.CSVPrinter;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.impl.DefaultResultHandler;

public abstract class CSVResultHandler
extends DefaultResultHandler {
    protected final ResultUtil util = new ResultUtil();
    protected volatile CSVPrinter csvPrinter = null;
    protected volatile boolean isClosed = true;

    @Override
    public synchronized void write(Result result) throws IOException {
        this.csvPrinter.printRecord(result.getResultValues());
        this.flush();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.csvPrinter != null) {
            this.csvPrinter.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.csvPrinter != null) {
            this.csvPrinter.flush();
            this.csvPrinter.close();
            this.isClosed = true;
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    protected abstract void open(String var1) throws IOException;
}

