/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryBase;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;

@FunctionParseNode.BuiltInFunction(name="SET_BIT", args={@FunctionParseNode.Argument(allowedTypes={PBinary.class, PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PInteger.class}), @FunctionParseNode.Argument(allowedTypes={PInteger.class})})
public class SetBitFunction
extends ScalarFunction {
    public static final String NAME = "SET_BIT";

    public SetBitFunction() {
    }

    public SetBitFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression offsetExpr = (Expression)this.children.get(1);
        if (!offsetExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int offset = (Integer)PInteger.INSTANCE.toObject(ptr, offsetExpr.getSortOrder());
        Expression newValueExpr = (Expression)this.children.get(2);
        if (!newValueExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int newValue = (Integer)PInteger.INSTANCE.toObject(ptr, newValueExpr.getSortOrder());
        byte newByteValue = (byte)(newValue & 1);
        Expression dataExpr = (Expression)this.children.get(0);
        if (!dataExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int len = ptr.getLength() * 8;
        offset = (offset % len + len) % len;
        ((PBinaryBase)dataExpr.getDataType()).setBit(ptr, dataExpr.getSortOrder(), offset, newByteValue, ptr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }
}

