/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="ROWKEY_BYTES_STRING", args={})
public class RowKeyBytesStringFunction
extends ScalarFunction {
    public static final String NAME = "ROWKEY_BYTES_STRING";

    public RowKeyBytesStringFunction() {
    }

    public RowKeyBytesStringFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        tuple.getKey(ptr);
        String rowkey = Bytes.toStringBinary((byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength());
        ptr.set(PVarchar.INSTANCE.toBytes(rowkey));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }

    @Override
    public boolean isStateless() {
        return false;
    }
}

