/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.coprocessor;

import com.google.common.base.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.coprocessor.CacheSupplier;
import org.apache.tephra.coprocessor.ReferenceCountedSupplier;
import org.apache.tephra.coprocessor.TransactionStateCache;

public class TransactionStateCacheSupplier
implements CacheSupplier<TransactionStateCache> {
    private static final ReferenceCountedSupplier<TransactionStateCache> referenceCountedSupplier = new ReferenceCountedSupplier(TransactionStateCache.class.getSimpleName());
    private final Supplier<TransactionStateCache> supplier;

    public TransactionStateCacheSupplier(Supplier<TransactionStateCache> supplier) {
        this.supplier = supplier;
    }

    public TransactionStateCacheSupplier(final Configuration conf) {
        this.supplier = new Supplier<TransactionStateCache>(){

            public TransactionStateCache get() {
                TransactionStateCache transactionStateCache = new TransactionStateCache();
                transactionStateCache.setConf(conf);
                return transactionStateCache;
            }
        };
    }

    @Override
    public TransactionStateCache get() {
        return referenceCountedSupplier.getOrCreate(this.supplier);
    }

    @Override
    public void release() {
        referenceCountedSupplier.release();
    }
}

