/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.phoenix.iterate.BufferedSortedQueue;
import org.apache.phoenix.iterate.BufferedTupleQueue;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.SizeAwareQueue;
import org.apache.phoenix.iterate.SizeBoundQueue;
import org.apache.phoenix.schema.tuple.Tuple;

public class PhoenixQueues {
    private PhoenixQueues() {
    }

    public static SizeAwareQueue<OrderedResultIterator.ResultEntry> newBufferedResultEntrySortedQueue(Comparator<OrderedResultIterator.ResultEntry> comparator, Integer limit, long thresholdBytes) throws IOException {
        return new BufferedSortedQueue(comparator, limit, thresholdBytes);
    }

    public static SizeAwareQueue<Tuple> newBufferedTupleQueue(long thresholdBytes) {
        return new BufferedTupleQueue(thresholdBytes);
    }

    public static SizeAwareQueue<OrderedResultIterator.ResultEntry> newSizeBoundResultEntrySortedQueue(Comparator<OrderedResultIterator.ResultEntry> comparator, Integer limit, long maxSizeBytes) {
        limit = limit == null ? -1 : limit;
        MinMaxPriorityQueue queue = limit < 0 ? MinMaxPriorityQueue.orderedBy(comparator).create() : MinMaxPriorityQueue.orderedBy(comparator).maximumSize(limit.intValue()).create();
        return new SizeBoundQueue<OrderedResultIterator.ResultEntry>(maxSizeBytes, (Queue)queue){

            @Override
            public long sizeOf(OrderedResultIterator.ResultEntry e) {
                return OrderedResultIterator.ResultEntry.sizeOf(e);
            }
        };
    }

    public static SizeAwareQueue<Tuple> newSizeBoundTupleQueue(long maxSizeBytes) {
        LinkedList results = Lists.newLinkedList();
        return new SizeBoundQueue<Tuple>(maxSizeBytes, (Queue)results){

            @Override
            public long sizeOf(Tuple e) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)e.getValue(0));
                return 8 + kv.getLength();
            }
        };
    }

    public static SizeAwareQueue<OrderedResultIterator.ResultEntry> newResultEntrySortedQueue(Comparator<OrderedResultIterator.ResultEntry> comparator, Integer limit, boolean spoolingEnabled, long thresholdBytes) throws IOException {
        if (spoolingEnabled) {
            return PhoenixQueues.newBufferedResultEntrySortedQueue(comparator, limit, thresholdBytes);
        }
        return PhoenixQueues.newSizeBoundResultEntrySortedQueue(comparator, limit, thresholdBytes);
    }

    public static SizeAwareQueue<Tuple> newTupleQueue(boolean spoolingEnabled, long thresholdBytes) {
        if (spoolingEnabled) {
            return PhoenixQueues.newBufferedTupleQueue(thresholdBytes);
        }
        return PhoenixQueues.newSizeBoundTupleQueue(thresholdBytes);
    }
}

