/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

@FunctionParseNode.BuiltInFunction(name="LTRIM", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class LTrimFunction
extends ScalarFunction {
    public static final String NAME = "LTRIM";

    public LTrimFunction() {
    }

    public LTrimFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    private Expression getStringExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public SortOrder getSortOrder() {
        return ((Expression)this.children.get(0)).getSortOrder();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        SortOrder sortOrder;
        int length;
        int offset;
        if (!this.getStringExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        byte[] string = ptr.get();
        int i = StringUtil.getFirstNonBlankCharIdxFromStart(string, offset = ptr.getOffset(), length = ptr.getLength(), sortOrder = this.getStringExpression().getSortOrder());
        if (i == offset + length) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        ptr.set(string, i, offset + length - i);
        return true;
    }

    @Override
    public Integer getMaxLength() {
        return this.getStringExpression().getMaxLength();
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

