/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.ArrayConstructorExpression;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.ByteBasedLikeExpression;
import org.apache.phoenix.expression.CaseExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.DateAddExpression;
import org.apache.phoenix.expression.DateSubtractExpression;
import org.apache.phoenix.expression.DecimalAddExpression;
import org.apache.phoenix.expression.DecimalDivideExpression;
import org.apache.phoenix.expression.DecimalMultiplyExpression;
import org.apache.phoenix.expression.DecimalSubtractExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.DoubleAddExpression;
import org.apache.phoenix.expression.DoubleDivideExpression;
import org.apache.phoenix.expression.DoubleMultiplyExpression;
import org.apache.phoenix.expression.DoubleSubtractExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.LongAddExpression;
import org.apache.phoenix.expression.LongDivideExpression;
import org.apache.phoenix.expression.LongMultiplyExpression;
import org.apache.phoenix.expression.LongSubtractExpression;
import org.apache.phoenix.expression.ModulusExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.OrExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.StringBasedLikeExpression;
import org.apache.phoenix.expression.StringConcatExpression;
import org.apache.phoenix.expression.TimestampAddExpression;
import org.apache.phoenix.expression.TimestampSubtractExpression;
import org.apache.phoenix.expression.function.ArrayAllComparisonExpression;
import org.apache.phoenix.expression.function.ArrayAnyComparisonExpression;
import org.apache.phoenix.expression.function.ArrayElemRefExpression;
import org.apache.phoenix.expression.function.RoundDecimalExpression;
import org.apache.phoenix.expression.function.RoundTimestampExpression;
import org.apache.phoenix.parse.AddParseNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ArithmeticParseNode;
import org.apache.phoenix.parse.ArrayAllComparisonNode;
import org.apache.phoenix.parse.ArrayAnyComparisonNode;
import org.apache.phoenix.parse.ArrayConstructorNode;
import org.apache.phoenix.parse.ArrayElemRefNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.DivideParseNode;
import org.apache.phoenix.parse.ExistsParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ModulusParseNode;
import org.apache.phoenix.parse.MultiplyParseNode;
import org.apache.phoenix.parse.NotParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.StringConcatParseNode;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.parse.SubtractParseNode;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.parse.UnsupportedAllParseNodeVisitor;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.DelegateDatum;
import org.apache.phoenix.schema.LocalIndexDataColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;

public class ExpressionCompiler
extends UnsupportedAllParseNodeVisitor<Expression> {
    private boolean isAggregate;
    protected ParseNode aggregateFunction;
    protected final StatementContext context;
    protected final GroupByCompiler.GroupBy groupBy;
    private int nodeCount;
    private int totalNodeCount;
    private final boolean resolveViewConstants;
    private static final Expression NOT_NULL_STRING = LiteralExpression.newConstant(PVarchar.INSTANCE.toObject(KeyRange.IS_NOT_NULL_RANGE.getLowerRange()));
    private static final PDatum DECIMAL_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        public PDataType getDataType() {
            return PDecimal.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };

    public ExpressionCompiler(StatementContext context) {
        this(context, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, false);
    }

    ExpressionCompiler(StatementContext context, boolean resolveViewConstants) {
        this(context, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, resolveViewConstants);
    }

    ExpressionCompiler(StatementContext context, GroupByCompiler.GroupBy groupBy) {
        this(context, groupBy, false);
    }

    ExpressionCompiler(StatementContext context, GroupByCompiler.GroupBy groupBy, boolean resolveViewConstants) {
        this.context = context;
        this.groupBy = groupBy;
        this.resolveViewConstants = resolveViewConstants;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isTopLevel() {
        return this.nodeCount == 0;
    }

    public void reset() {
        this.isAggregate = false;
        this.nodeCount = 0;
        this.totalNodeCount = 0;
    }

    @Override
    public boolean visitEnter(ComparisonParseNode node) {
        return true;
    }

    private void addBindParamMetaData(ParseNode lhsNode, ParseNode rhsNode, Expression lhsExpr, Expression rhsExpr) throws SQLException {
        if (lhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)lhsNode, rhsExpr);
        }
        if (rhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)rhsNode, lhsExpr);
        }
    }

    @Override
    public Expression visitLeave(ComparisonParseNode node, List<Expression> children) throws SQLException {
        ParseNode lhsNode = node.getChildren().get(0);
        ParseNode rhsNode = node.getChildren().get(1);
        Expression lhsExpr = children.get(0);
        Expression rhsExpr = children.get(1);
        CompareFilter.CompareOp op = node.getFilterOp();
        if (lhsNode instanceof RowValueConstructorParseNode && rhsNode instanceof RowValueConstructorParseNode) {
            int i;
            for (i = 0; i < Math.min(lhsExpr.getChildren().size(), rhsExpr.getChildren().size()); ++i) {
                this.addBindParamMetaData(lhsNode.getChildren().get(i), rhsNode.getChildren().get(i), lhsExpr.getChildren().get(i), rhsExpr.getChildren().get(i));
            }
            while (i < lhsExpr.getChildren().size()) {
                this.addBindParamMetaData(lhsNode.getChildren().get(i), null, lhsExpr.getChildren().get(i), null);
                ++i;
            }
            while (i < rhsExpr.getChildren().size()) {
                this.addBindParamMetaData(null, rhsNode.getChildren().get(i), null, rhsExpr.getChildren().get(i));
                ++i;
            }
        } else if (lhsExpr instanceof RowValueConstructorExpression) {
            this.addBindParamMetaData(lhsNode.getChildren().get(0), rhsNode, lhsExpr.getChildren().get(0), rhsExpr);
            for (int i = 1; i < lhsExpr.getChildren().size(); ++i) {
                this.addBindParamMetaData(lhsNode.getChildren().get(i), null, lhsExpr.getChildren().get(i), null);
            }
        } else if (rhsExpr instanceof RowValueConstructorExpression) {
            this.addBindParamMetaData(lhsNode, rhsNode.getChildren().get(0), lhsExpr, rhsExpr.getChildren().get(0));
            for (int i = 1; i < rhsExpr.getChildren().size(); ++i) {
                this.addBindParamMetaData(null, rhsNode.getChildren().get(i), null, rhsExpr.getChildren().get(i));
            }
        } else {
            this.addBindParamMetaData(lhsNode, rhsNode, lhsExpr, rhsExpr);
        }
        return this.wrapGroupByExpression(ComparisonExpression.create(op, children, this.context.getTempPtr(), this.context.getCurrentTable().getTable().rowKeyOrderOptimizable()));
    }

    @Override
    public boolean visitEnter(AndParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(AndParseNode node, List<Expression> children) throws SQLException {
        return this.wrapGroupByExpression(AndExpression.create(children));
    }

    @Override
    public boolean visitEnter(OrParseNode node) throws SQLException {
        return true;
    }

    private Expression orExpression(List<Expression> children) throws SQLException {
        Iterator<Expression> iterator = children.iterator();
        Determinism determinism = Determinism.ALWAYS;
        while (iterator.hasNext()) {
            Expression child = iterator.next();
            if (child.getDataType() != PBoolean.INSTANCE) {
                throw TypeMismatchException.newException(PBoolean.INSTANCE, child.getDataType(), child.toString());
            }
            if (LiteralExpression.isFalse(child)) {
                iterator.remove();
            }
            if (LiteralExpression.isTrue(child)) {
                return child;
            }
            determinism = determinism.combine(child.getDeterminism());
        }
        if (children.size() == 0) {
            return LiteralExpression.newConstant((Object)false, determinism);
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return new OrExpression(children);
    }

    @Override
    public Expression visitLeave(OrParseNode node, List<Expression> children) throws SQLException {
        return this.wrapGroupByExpression(this.orExpression(children));
    }

    @Override
    public boolean visitEnter(FunctionParseNode node) throws SQLException {
        if (node.isAggregate()) {
            if (this.aggregateFunction != null) {
                throw new SQLFeatureNotSupportedException("Nested aggregate functions are not supported");
            }
            this.aggregateFunction = node;
            this.isAggregate = true;
        }
        return true;
    }

    private Expression wrapGroupByExpression(Expression expression) {
        int index;
        if (this.aggregateFunction == null && (index = this.groupBy.getExpressions().indexOf(expression)) >= 0) {
            this.isAggregate = true;
            expression = ExpressionUtil.convertGroupByExpressionToRowKeyColumnExpression(this.groupBy, expression, index);
        }
        return expression;
    }

    protected Expression addExpression(Expression expression) {
        return this.context.getExpressionManager().addIfAbsent(expression);
    }

    @Override
    public Expression visitLeave(FunctionParseNode node, List<Expression> children) throws SQLException {
        PFunction function = null;
        if (node instanceof UDFParseNode) {
            function = this.context.getResolver().resolveFunction(node.getName());
            FunctionParseNode.BuiltInFunctionInfo info = new FunctionParseNode.BuiltInFunctionInfo(function);
            node = new UDFParseNode(node.getName(), node.getChildren(), info);
        }
        children = node.validate(children, this.context);
        Expression expression = null;
        expression = function == null ? node.create(children, this.context) : node.create(children, function, this.context);
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        FunctionParseNode.BuiltInFunctionInfo info = node.getInfo();
        for (int i = 0; i < info.getRequiredArgCount(); ++i) {
            Expression child;
            if (!node.evalToNullIfParamIsNull(this.context, i) || !ExpressionUtil.isNull(child = children.get(i), ptr)) continue;
            return ExpressionUtil.getNullExpression(expression);
        }
        if (ExpressionUtil.isConstant(expression)) {
            return ExpressionUtil.getConstantExpression(expression, ptr);
        }
        expression = this.addExpression(expression);
        expression = this.wrapGroupByExpression(expression);
        if (this.aggregateFunction == node) {
            this.aggregateFunction = null;
        }
        return expression;
    }

    protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
        boolean isSharedViewIndex;
        boolean isMultiTenant;
        boolean isSalted;
        int minPosition;
        ColumnRef ref = null;
        try {
            ref = this.context.getResolver().resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
        }
        catch (ColumnNotFoundException e) {
            if (this.context.getCurrentTable().getTable().getIndexType() == PTable.IndexType.LOCAL) {
                try {
                    return new LocalIndexDataColumnRef(this.context, this.context.getCurrentTable(), node.getName());
                }
                catch (ColumnFamilyNotFoundException c) {
                    throw e;
                }
            }
            throw e;
        }
        PTable table = ref.getTable();
        int pkPosition = ref.getPKSlotPosition();
        if (pkPosition >= 0 && pkPosition < (minPosition = ((isSalted = table.getBucketNum() != null) ? 1 : 0) + ((isMultiTenant = this.context.getConnection().getTenantId() != null && table.isMultiTenant()) ? 1 : 0) + ((isSharedViewIndex = table.getViewIndexId() != null) ? 1 : 0))) {
            throw new ColumnNotFoundException(table.getSchemaName().getString(), table.getTableName().getString(), null, ref.getColumn().getName().getString());
        }
        return ref;
    }

    protected void addColumn(PColumn column) {
        EncodedColumnsUtil.setColumns(column, this.context.getCurrentTable().getTable(), this.context.getScan());
    }

    @Override
    public Expression visit(ColumnParseNode node) throws SQLException {
        ColumnRef ref = this.resolveColumn(node);
        TableRef tableRef = ref.getTableRef();
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        PColumn column = ref.getColumn();
        if (!this.resolveViewConstants && IndexUtil.getViewConstantValue(column, ptr)) {
            return LiteralExpression.newConstant(column.getDataType().toObject(ptr), column.getDataType());
        }
        if (tableRef.equals(this.context.getCurrentTable()) && !SchemaUtil.isPKColumn(column)) {
            this.addColumn(column);
        }
        Expression expression = ref.newColumnExpression(node.isTableNameCaseSensitive(), node.isCaseSensitive());
        Expression wrappedExpression = this.wrapGroupByExpression(expression);
        if (this.isAggregate && this.aggregateFunction == null && wrappedExpression == expression) {
            ExpressionCompiler.throwNonAggExpressionInAggException(expression.toString());
        }
        return wrappedExpression;
    }

    @Override
    public Expression visit(BindParseNode node) throws SQLException {
        Object value = this.context.getBindManager().getBindValue(node);
        return LiteralExpression.newConstant(value, Determinism.ALWAYS);
    }

    @Override
    public Expression visit(LiteralParseNode node) throws SQLException {
        return LiteralExpression.newConstant(node.getValue(), node.getType(), Determinism.ALWAYS);
    }

    @Override
    public List<Expression> newElementList(int size) {
        this.nodeCount += size;
        return new ArrayList<Expression>(size);
    }

    @Override
    public void addElement(List<Expression> l, Expression element) {
        --this.nodeCount;
        ++this.totalNodeCount;
        l.add(element);
    }

    @Override
    public boolean visitEnter(CaseParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(CaseParseNode node, List<Expression> l) throws SQLException {
        Expression caseExpression = CaseExpression.create(l);
        for (int i = 0; i < node.getChildren().size(); i += 2) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, new DelegateDatum(caseExpression));
        }
        return this.wrapGroupByExpression(caseExpression);
    }

    @Override
    public boolean visitEnter(LikeParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(LikeParseNode node, List<Expression> children) throws SQLException {
        ConnectionQueryServices services;
        boolean useByteBasedRegex;
        BaseExpression expression;
        ParseNode lhsNode = node.getChildren().get(0);
        ParseNode rhsNode = node.getChildren().get(1);
        Expression lhs = children.get(0);
        Expression rhs = children.get(1);
        if (rhs.getDataType() != null && lhs.getDataType() != null && !lhs.getDataType().isCoercibleTo(rhs.getDataType()) && !rhs.getDataType().isCoercibleTo(lhs.getDataType())) {
            throw TypeMismatchException.newException(lhs.getDataType(), rhs.getDataType(), node.toString());
        }
        if (lhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)lhsNode, rhs);
        }
        if (rhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)rhsNode, lhs);
        }
        if (rhs instanceof LiteralExpression) {
            String pattern = (String)((LiteralExpression)rhs).getValue();
            if (pattern == null || pattern.length() == 0) {
                return LiteralExpression.newConstant(null, (PDataType)PBoolean.INSTANCE, rhs.getDeterminism());
            }
            int index = LikeExpression.indexOfWildcard(pattern);
            Integer lhsMaxLength = lhs.getMaxLength();
            if (lhsMaxLength != null && lhsMaxLength < index) {
                return LiteralExpression.newConstant((Object)false, rhs.getDeterminism());
            }
            if (index == -1) {
                String rhsLiteral = LikeExpression.unescapeLike(pattern);
                if (node.getLikeType() == LikeParseNode.LikeType.CASE_SENSITIVE) {
                    CompareFilter.CompareOp op;
                    CompareFilter.CompareOp compareOp = op = node.isNegate() ? CompareFilter.CompareOp.NOT_EQUAL : CompareFilter.CompareOp.EQUAL;
                    if (pattern.equals(rhsLiteral)) {
                        return new ComparisonExpression(children, op);
                    }
                    rhs = LiteralExpression.newConstant((Object)rhsLiteral, (PDataType)PChar.INSTANCE, rhs.getDeterminism());
                    return new ComparisonExpression(Arrays.asList(lhs, rhs), op);
                }
            } else {
                byte[] wildcardString = new byte[pattern.length()];
                byte[] wildcard = new byte[]{37};
                StringUtil.fill(wildcardString, 0, pattern.length(), wildcard, 0, 1, false);
                if (pattern.equals(new String(wildcardString))) {
                    List<Expression> compareChildren = Arrays.asList(lhs, NOT_NULL_STRING);
                    return new ComparisonExpression(compareChildren, node.isNegate() ? CompareFilter.CompareOp.LESS : CompareFilter.CompareOp.GREATER_OR_EQUAL);
                }
            }
        }
        if (ExpressionUtil.isConstant(expression = (useByteBasedRegex = (services = this.context.getConnection().getQueryServices()).getProps().getBoolean("phoenix.regex.byteBased", false)) ? ByteBasedLikeExpression.create(children, node.getLikeType()) : StringBasedLikeExpression.create(children, node.getLikeType()))) {
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            if (!expression.evaluate(null, ptr)) {
                return LiteralExpression.newConstant(null, expression.getDeterminism());
            }
            return LiteralExpression.newConstant((Object)(Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr)) ^ node.isNegate()), expression.getDeterminism());
        }
        if (node.isNegate()) {
            expression = new NotExpression(expression);
        }
        return this.wrapGroupByExpression(expression);
    }

    @Override
    public boolean visitEnter(NotParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(NotParseNode node, List<Expression> children) throws SQLException {
        ParseNode childNode = node.getChildren().get(0);
        Expression child = children.get(0);
        if (!PBoolean.INSTANCE.isCoercibleTo(child.getDataType())) {
            throw TypeMismatchException.newException(PBoolean.INSTANCE, child.getDataType(), node.toString());
        }
        if (childNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, child);
        }
        return this.wrapGroupByExpression(NotExpression.create(child, this.context.getTempPtr()));
    }

    @Override
    public boolean visitEnter(CastParseNode node) throws SQLException {
        return true;
    }

    private static Expression convertToRoundExpressionIfNeeded(PDataType fromDataType, PDataType targetDataType, List<Expression> expressions) throws SQLException {
        Expression firstChildExpr = expressions.get(0);
        if (fromDataType == targetDataType) {
            return firstChildExpr;
        }
        if ((fromDataType == PDecimal.INSTANCE || fromDataType == PTimestamp.INSTANCE || fromDataType == PUnsignedTimestamp.INSTANCE) && targetDataType.isCoercibleTo(PLong.INSTANCE)) {
            return RoundDecimalExpression.create(expressions);
        }
        if ((fromDataType == PDecimal.INSTANCE || fromDataType == PTimestamp.INSTANCE || fromDataType == PUnsignedTimestamp.INSTANCE) && targetDataType.isCoercibleTo(PDate.INSTANCE)) {
            return RoundTimestampExpression.create(expressions);
        }
        if (fromDataType.isCastableTo(targetDataType)) {
            return firstChildExpr;
        }
        throw TypeMismatchException.newException(fromDataType, targetDataType, firstChildExpr.toString());
    }

    @Override
    public Expression visitLeave(CastParseNode node, List<Expression> children) throws SQLException {
        ParseNode childNode = node.getChildren().get(0);
        PDataType targetDataType = node.getDataType();
        Expression childExpr = children.get(0);
        PDataType fromDataType = childExpr.getDataType();
        if (childNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, childExpr);
        }
        Expression expr = childExpr;
        if (fromDataType != null && this.context.getCurrentTable().getTable().getType() != PTableType.INDEX) {
            expr = ExpressionCompiler.convertToRoundExpressionIfNeeded(fromDataType, targetDataType, children);
        }
        boolean rowKeyOrderOptimizable = this.context.getCurrentTable().getTable().rowKeyOrderOptimizable();
        return this.wrapGroupByExpression(CoerceExpression.create(expr, targetDataType, SortOrder.getDefault(), expr.getMaxLength(), rowKeyOrderOptimizable));
    }

    @Override
    public boolean visitEnter(InListParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(InListParseNode node, List<Expression> l) throws SQLException {
        List<Expression> inChildren = l;
        Expression firstChild = inChildren.get(0);
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        PDataType firstChildType = firstChild.getDataType();
        ParseNode firstChildNode = node.getChildren().get(0);
        if (firstChildNode instanceof BindParseNode) {
            PDatum datum = firstChild;
            if (firstChildType == null) {
                datum = ExpressionCompiler.inferBindDatum(inChildren);
            }
            this.context.getBindManager().addParamMetaData((BindParseNode)firstChildNode, datum);
        }
        for (int i = 1; i < l.size(); ++i) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, firstChild);
        }
        return this.wrapGroupByExpression(InListExpression.create(inChildren, node.isNegate(), ptr, this.context.getCurrentTable().getTable().rowKeyOrderOptimizable()));
    }

    private static PDatum inferBindDatum(List<Expression> children) {
        boolean isChildTypeUnknown = false;
        PDatum datum = children.get(1);
        for (int i = 2; i < children.size(); ++i) {
            Expression child = children.get(i);
            PDataType childType = child.getDataType();
            if (childType == null) {
                isChildTypeUnknown = true;
                continue;
            }
            if (datum.getDataType() == null) {
                datum = child;
                isChildTypeUnknown = true;
                continue;
            }
            if (datum.getDataType() == childType || childType.isCoercibleTo(datum.getDataType()) || !datum.getDataType().isCoercibleTo(childType)) continue;
            datum = child;
        }
        if (isChildTypeUnknown && datum.getDataType() != null && datum.getDataType().isCoercibleTo(PDecimal.INSTANCE)) {
            return DECIMAL_DATUM;
        }
        return datum;
    }

    @Override
    public boolean visitEnter(IsNullParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(IsNullParseNode node, List<Expression> children) throws SQLException {
        ParseNode childNode = node.getChildren().get(0);
        Expression child = children.get(0);
        if (childNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, child);
        }
        return this.wrapGroupByExpression(IsNullExpression.create(child, node.isNegate(), this.context.getTempPtr()));
    }

    private Expression visitLeave(ArithmeticParseNode node, List<Expression> children, ArithmeticExpressionBinder binder, ArithmeticExpressionFactory factory) throws SQLException {
        boolean isNull = false;
        for (Expression child : children) {
            boolean isChildLiteral = child instanceof LiteralExpression;
            isNull |= isChildLiteral && ((LiteralExpression)child).getValue() == null;
        }
        Expression expression = factory.create(node, children);
        for (int i = 0; i < node.getChildren().size(); ++i) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, binder == null ? expression : binder.getBindMetaData(i, children, expression));
        }
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        if (ExpressionUtil.isConstant(expression)) {
            return ExpressionUtil.getConstantExpression(expression, ptr);
        }
        if (isNull) {
            return LiteralExpression.newConstant(null, expression.getDataType(), expression.getDeterminism());
        }
        return this.wrapGroupByExpression(expression);
    }

    @Override
    public boolean visitEnter(AddParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(AddParseNode node, List<Expression> children) throws SQLException {
        return this.visitLeave(node, children, new ArithmeticExpressionBinder(){

            @Override
            public PDatum getBindMetaData(int i, List<Expression> children, Expression expression) {
                PDataType type = expression.getDataType();
                if (type != null && type.isCoercibleTo(PDate.INSTANCE)) {
                    return ExpressionCompiler.this.getPDatumByExpression(expression, PDecimal.INSTANCE);
                }
                return expression;
            }
        }, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                boolean foundDate = false;
                Determinism determinism = Determinism.ALWAYS;
                PDataType theType = null;
                for (int i = 0; i < children.size(); ++i) {
                    Expression e = children.get(i);
                    determinism = determinism.combine(e.getDeterminism());
                    PDataType type = e.getDataType();
                    if (type == null) continue;
                    if (type.isCoercibleTo(PTimestamp.INSTANCE)) {
                        if (foundDate) {
                            throw TypeMismatchException.newException(type, node.toString());
                        }
                        if (theType == null || theType != PTimestamp.INSTANCE && theType != PUnsignedTimestamp.INSTANCE) {
                            theType = type;
                        }
                        foundDate = true;
                        continue;
                    }
                    if (type == PDecimal.INSTANCE) {
                        if (theType != null && theType.isCoercibleTo(PTimestamp.INSTANCE)) continue;
                        theType = PDecimal.INSTANCE;
                        continue;
                    }
                    if (type.isCoercibleTo(PLong.INSTANCE)) {
                        if (theType != null) continue;
                        theType = PLong.INSTANCE;
                        continue;
                    }
                    if (type.isCoercibleTo(PDouble.INSTANCE)) {
                        if (theType != null) continue;
                        theType = PDouble.INSTANCE;
                        continue;
                    }
                    throw TypeMismatchException.newException(type, node.toString());
                }
                if (theType == PDecimal.INSTANCE) {
                    return new DecimalAddExpression(children);
                }
                if (theType == PLong.INSTANCE) {
                    return new LongAddExpression(children);
                }
                if (theType == PDouble.INSTANCE) {
                    return new DoubleAddExpression(children);
                }
                if (theType == null) {
                    return LiteralExpression.newConstant(null, theType, determinism);
                }
                if (theType == PTimestamp.INSTANCE || theType == PUnsignedTimestamp.INSTANCE) {
                    return new TimestampAddExpression(children);
                }
                if (theType.isCoercibleTo(PDate.INSTANCE)) {
                    return new DateAddExpression(children);
                }
                throw TypeMismatchException.newException(theType, node.toString());
            }
        });
    }

    @Override
    public boolean visitEnter(SubtractParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(SubtractParseNode node, List<Expression> children) throws SQLException {
        return this.visitLeave(node, children, new ArithmeticExpressionBinder(){

            @Override
            public PDatum getBindMetaData(int i, List<Expression> children, Expression expression) {
                PDataType type;
                if (i == 0 && (type = children.get(1).getDataType()) != null && type.isCoercibleTo(PDate.INSTANCE)) {
                    return ExpressionCompiler.this.getPDatumByExpression(expression, type);
                }
                if (expression.getDataType() != null && expression.getDataType().isCoercibleTo(PDate.INSTANCE)) {
                    return ExpressionCompiler.this.getPDatumByExpression(expression, PDecimal.INSTANCE);
                }
                return expression;
            }
        }, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                boolean isType2Date;
                int i = 0;
                PDataType theType = null;
                Expression e1 = children.get(0);
                Expression e2 = children.get(1);
                Determinism determinism = e1.getDeterminism().combine(e2.getDeterminism());
                PDataType type1 = e1.getDataType();
                PDataType type2 = e2.getDataType();
                boolean isType1Date = type1 != null && type1 != PTimestamp.INSTANCE && type1 != PUnsignedTimestamp.INSTANCE && type1.isCoercibleTo(PDate.INSTANCE);
                boolean bl = isType2Date = type2 != null && type2 != PTimestamp.INSTANCE && type2 != PUnsignedTimestamp.INSTANCE && type2.isCoercibleTo(PDate.INSTANCE);
                if (isType1Date || isType2Date) {
                    if (isType1Date && isType2Date) {
                        i = 2;
                        theType = PDecimal.INSTANCE;
                    } else if (isType1Date && type2 != null && type2.isCoercibleTo(PDecimal.INSTANCE)) {
                        i = 2;
                        theType = PDate.INSTANCE;
                    } else if (type1 == null || type2 == null) {
                        i = 2;
                        theType = null;
                    }
                } else if (type1 == PTimestamp.INSTANCE || type2 == PTimestamp.INSTANCE) {
                    i = 2;
                    theType = PTimestamp.INSTANCE;
                } else if (type1 == PUnsignedTimestamp.INSTANCE || type2 == PUnsignedTimestamp.INSTANCE) {
                    i = 2;
                    theType = PUnsignedTimestamp.INSTANCE;
                }
                while (i < children.size()) {
                    Expression e = children.get(i);
                    determinism = determinism.combine(e.getDeterminism());
                    PDataType type = e.getDataType();
                    if (type != null) {
                        if (type.isCoercibleTo(PLong.INSTANCE)) {
                            if (theType == null) {
                                theType = PLong.INSTANCE;
                            }
                        } else if (type == PDecimal.INSTANCE) {
                            if (theType == null || !theType.isCoercibleTo(PDate.INSTANCE)) {
                                theType = PDecimal.INSTANCE;
                            }
                        } else if (type.isCoercibleTo(PDouble.INSTANCE)) {
                            if (theType == null || theType != PDecimal.INSTANCE && !theType.isCoercibleTo(PDate.INSTANCE)) {
                                theType = PDouble.INSTANCE;
                            }
                        } else {
                            throw TypeMismatchException.newException(type, node.toString());
                        }
                    }
                    ++i;
                }
                if (theType == PDecimal.INSTANCE) {
                    return new DecimalSubtractExpression(children);
                }
                if (theType == PLong.INSTANCE) {
                    return new LongSubtractExpression(children);
                }
                if (theType == PDouble.INSTANCE) {
                    return new DoubleSubtractExpression(children);
                }
                if (theType == null) {
                    return LiteralExpression.newConstant(null, theType, determinism);
                }
                if (theType == PTimestamp.INSTANCE || theType == PUnsignedTimestamp.INSTANCE) {
                    return new TimestampSubtractExpression(children);
                }
                if (theType.isCoercibleTo(PDate.INSTANCE)) {
                    return new DateSubtractExpression(children);
                }
                throw TypeMismatchException.newException(theType, node.toString());
            }
        });
    }

    @Override
    public boolean visitEnter(MultiplyParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(MultiplyParseNode node, List<Expression> children) throws SQLException {
        return this.visitLeave(node, children, null, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                PDataType theType = null;
                Determinism determinism = Determinism.ALWAYS;
                ExpressionDeterminism expressionDeterminism = new ExpressionDeterminism(node, children, theType, determinism).invoke();
                theType = expressionDeterminism.getDataType();
                determinism = expressionDeterminism.getDeterminism();
                if (theType == PDecimal.INSTANCE) {
                    return new DecimalMultiplyExpression(children);
                }
                if (theType == PLong.INSTANCE) {
                    return new LongMultiplyExpression(children);
                }
                if (theType == PDouble.INSTANCE) {
                    return new DoubleMultiplyExpression(children);
                }
                return LiteralExpression.newConstant(null, theType, determinism);
            }
        });
    }

    @Override
    public boolean visitEnter(DivideParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(DivideParseNode node, List<Expression> children) throws SQLException {
        for (int i = 1; i < children.size(); ++i) {
            LiteralExpression literal;
            Expression child = children.get(i);
            if (child.getDataType() == null || !(child instanceof LiteralExpression) || !((literal = (LiteralExpression)child).getDataType() == PDecimal.INSTANCE ? PDecimal.INSTANCE.compareTo(literal.getValue(), BigDecimal.ZERO) == 0 : literal.getDataType().compareTo(literal.getValue(), 0L, PLong.INSTANCE) == 0)) continue;
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.DIVIDE_BY_ZERO).build().buildException();
        }
        return this.visitLeave(node, children, null, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                PDataType theType = null;
                Determinism determinism = Determinism.ALWAYS;
                ExpressionDeterminism expressionDeterminism = new ExpressionDeterminism(node, children, theType, determinism).invoke();
                theType = expressionDeterminism.getDataType();
                determinism = expressionDeterminism.getDeterminism();
                if (theType == PDecimal.INSTANCE) {
                    return new DecimalDivideExpression(children);
                }
                if (theType == PLong.INSTANCE) {
                    return new LongDivideExpression(children);
                }
                if (theType == PDouble.INSTANCE) {
                    return new DoubleDivideExpression(children);
                }
                return LiteralExpression.newConstant(null, theType, determinism);
            }
        });
    }

    @Override
    public boolean visitEnter(ModulusParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(ModulusParseNode node, List<Expression> children) throws SQLException {
        return this.visitLeave(node, children, null, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                for (Expression child : children) {
                    PDataType type = child.getDataType();
                    if (type == null || type.isCoercibleTo(PLong.INSTANCE)) continue;
                    throw TypeMismatchException.newException(type, node.toString());
                }
                return new ModulusExpression(children);
            }
        });
    }

    @Override
    public boolean visitEnter(ArrayAnyComparisonNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(ArrayAnyComparisonNode node, List<Expression> children) throws SQLException {
        return new ArrayAnyComparisonExpression(children);
    }

    @Override
    public boolean visitEnter(ArrayAllComparisonNode node) throws SQLException {
        return true;
    }

    @Override
    public boolean visitEnter(ArrayElemRefNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(ArrayElemRefNode node, List<Expression> l) throws SQLException {
        return new ArrayElemRefExpression(l);
    }

    @Override
    public Expression visitLeave(ArrayAllComparisonNode node, List<Expression> children) throws SQLException {
        return new ArrayAllComparisonExpression(children);
    }

    public static void throwNonAggExpressionInAggException(String nonAggregateExpression) throws SQLException {
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_WITH_NOT_GROUP_BY_COLUMN).setMessage(nonAggregateExpression).build().buildException();
    }

    @Override
    public Expression visitLeave(StringConcatParseNode node, List<Expression> children) throws SQLException {
        StringConcatExpression expression = new StringConcatExpression(children);
        for (int i = 0; i < children.size(); ++i) {
            PDataType type;
            ParseNode childNode = node.getChildren().get(i);
            if (childNode instanceof BindParseNode) {
                this.context.getBindManager().addParamMetaData((BindParseNode)childNode, expression);
            }
            if ((type = children.get(i).getDataType()) != PVarbinary.INSTANCE) continue;
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_NOT_SUPPORTED_FOR_OPERATOR).setMessage("Concatenation does not support " + type + " in expression" + node).build().buildException();
        }
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        if (ExpressionUtil.isConstant(expression)) {
            return ExpressionUtil.getConstantExpression(expression, ptr);
        }
        return this.wrapGroupByExpression(expression);
    }

    @Override
    public boolean visitEnter(StringConcatParseNode node) throws SQLException {
        return true;
    }

    @Override
    public boolean visitEnter(RowValueConstructorParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(RowValueConstructorParseNode node, List<Expression> l) throws SQLException {
        return this.wrapGroupByExpression(new RowValueConstructorExpression(l, node.isStateless()));
    }

    @Override
    public Expression visit(SequenceValueParseNode node) throws SQLException {
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_USE_OF_NEXT_VALUE_FOR).setSchemaName(node.getTableName().getSchemaName()).setTableName(node.getTableName().getTableName()).build().buildException();
    }

    @Override
    public Expression visitLeave(ArrayConstructorNode node, List<Expression> children) throws SQLException {
        boolean isChildTypeUnknown = false;
        Expression arrayElemChild = null;
        PDataType arrayElemDataType = children.get(0).getDataType();
        for (int i = 0; i < children.size(); ++i) {
            Expression child = children.get(i);
            PDataType childType = child.getDataType();
            if (childType == null) {
                isChildTypeUnknown = true;
                continue;
            }
            if (arrayElemDataType == null) {
                arrayElemDataType = childType;
                isChildTypeUnknown = true;
                arrayElemChild = child;
                continue;
            }
            if (arrayElemDataType == childType || childType.isCoercibleTo(arrayElemDataType)) continue;
            if (arrayElemDataType.isCoercibleTo(childType)) {
                arrayElemChild = child;
                arrayElemDataType = childType;
                continue;
            }
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_MISMATCH).setMessage("Case expressions must have common type: " + arrayElemDataType + " cannot be coerced to " + childType).build().buildException();
        }
        if (isChildTypeUnknown && arrayElemDataType != null && arrayElemDataType.isCoercibleTo(PDecimal.INSTANCE)) {
            arrayElemDataType = PDecimal.INSTANCE;
        }
        final PDataType theArrayElemDataType = arrayElemDataType;
        for (int i = 0; i < node.getChildren().size(); ++i) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, arrayElemDataType == arrayElemChild.getDataType() ? arrayElemChild : new DelegateDatum(arrayElemChild){

                @Override
                public PDataType getDataType() {
                    return theArrayElemDataType;
                }
            });
        }
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        Object[] elements = (Object[])Array.newInstance(theArrayElemDataType.getJavaClass(), children.size());
        boolean rowKeyOrderOptimizable = this.context.getCurrentTable().getTable().rowKeyOrderOptimizable();
        ArrayConstructorExpression arrayExpression = new ArrayConstructorExpression(children, arrayElemDataType, rowKeyOrderOptimizable);
        if (ExpressionUtil.isConstant(arrayExpression)) {
            for (int i = 0; i < children.size(); ++i) {
                Expression child = children.get(i);
                child.evaluate(null, ptr);
                Object value = null;
                value = child.getDataType() == null ? arrayElemDataType.toObject(ptr, theArrayElemDataType, child.getSortOrder()) : arrayElemDataType.toObject(ptr, child.getDataType(), child.getSortOrder());
                elements[i] = LiteralExpression.newConstant(value, theArrayElemDataType, child.getDeterminism()).getValue();
            }
            PhoenixArray value = PArrayDataType.instantiatePhoenixArray(arrayElemDataType, elements);
            return LiteralExpression.newConstant(value, PDataType.fromTypeId(arrayElemDataType.getSqlType() + 3000), null, null, arrayExpression.getSortOrder(), Determinism.ALWAYS, rowKeyOrderOptimizable);
        }
        return this.wrapGroupByExpression(arrayExpression);
    }

    @Override
    public boolean visitEnter(ArrayConstructorNode node) throws SQLException {
        return true;
    }

    @Override
    public boolean visitEnter(ExistsParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(ExistsParseNode node, List<Expression> l) throws SQLException {
        LiteralExpression child = (LiteralExpression)l.get(0);
        boolean elementExists = child != null && child.getValue() != null && ((PhoenixArray)child.getValue()).getDimensions() > 0;
        return LiteralExpression.newConstant((Object)(elementExists ^ node.isNegate()), PBoolean.INSTANCE);
    }

    @Override
    public Expression visit(SubqueryParseNode node) throws SQLException {
        Object result = this.context.getSubqueryResult(node.getSelectNode());
        return LiteralExpression.newConstant(result);
    }

    public int getTotalNodeCount() {
        return this.totalNodeCount;
    }

    private PDatum getPDatumByExpression(Expression expression, PDataType pDataTypeInput) {
        return new PDatumImpl(expression, pDataTypeInput);
    }

    private static class ExpressionDeterminism {
        private ArithmeticParseNode node;
        private List<Expression> children;
        private PDataType theType;
        private Determinism determinism;

        ExpressionDeterminism(ArithmeticParseNode node, List<Expression> children, PDataType theType, Determinism determinism) {
            this.node = node;
            this.children = children;
            this.theType = theType;
            this.determinism = determinism;
        }

        PDataType getDataType() {
            return this.theType;
        }

        Determinism getDeterminism() {
            return this.determinism;
        }

        public ExpressionDeterminism invoke() throws TypeMismatchException {
            for (Expression e : this.children) {
                this.determinism = this.determinism.combine(e.getDeterminism());
                PDataType type = e.getDataType();
                if (type == null) continue;
                if (type == PDecimal.INSTANCE) {
                    this.theType = PDecimal.INSTANCE;
                    continue;
                }
                if (type.isCoercibleTo(PLong.INSTANCE)) {
                    if (this.theType != null) continue;
                    this.theType = PLong.INSTANCE;
                    continue;
                }
                if (type.isCoercibleTo(PDouble.INSTANCE)) {
                    if (this.theType != null) continue;
                    this.theType = PDouble.INSTANCE;
                    continue;
                }
                throw TypeMismatchException.newException(type, this.node.toString());
            }
            return this;
        }
    }

    private static class PDatumImpl
    implements PDatum {
        private final boolean isNullable;
        private final PDataType dataType;
        private final Integer maxLength;
        private final Integer scale;
        private final SortOrder sortOrder;

        PDatumImpl(Expression expression, PDataType pDataTypeInput) {
            this.isNullable = expression.isNullable();
            this.dataType = pDataTypeInput;
            this.maxLength = expression.getMaxLength();
            this.scale = expression.getScale();
            this.sortOrder = expression.getSortOrder();
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        @Override
        public PDataType getDataType() {
            return this.dataType;
        }

        @Override
        public Integer getMaxLength() {
            return this.maxLength;
        }

        @Override
        public Integer getScale() {
            return this.scale;
        }

        @Override
        public SortOrder getSortOrder() {
            return this.sortOrder;
        }
    }

    private static interface ArithmeticExpressionBinder {
        public PDatum getBindMetaData(int var1, List<Expression> var2, Expression var3);
    }

    private static interface ArithmeticExpressionFactory {
        public Expression create(ArithmeticParseNode var1, List<Expression> var2) throws SQLException;
    }
}

