/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.util.AssertUtils;

public final class IOUtils {
    private static final int BUFFER_SIZE = 8192;

    public static String toString(@NonNull InputStream in, @NonNull Charset encoding) throws IOException {
        AssertUtils.notNull(in, "in must not be null");
        AssertUtils.notNull(encoding, "encoding must not be null");
        StringBuilder builder = new StringBuilder();
        try (BufferedReader source = new BufferedReader(new InputStreamReader(in, encoding));){
            int n;
            char[] buf = new char[8192];
            while ((n = source.read(buf)) > 0) {
                builder.append(buf, 0, n);
            }
        }
        return builder.toString();
    }

    public static long copy(@NonNull InputStream in, @NonNull OutputStream out) throws IOException {
        int n;
        AssertUtils.notNull(in, "in must not be null");
        AssertUtils.notNull(out, "out must not be null");
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    private IOUtils() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

