/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.collection;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.util.collection.InflatableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

@SerializableByConvention
public final class ImmutableInflatableSet<T>
extends InflatableSet<T> {
    private static final long serialVersionUID = 1L;

    private ImmutableInflatableSet(List<T> compactList) {
        super(compactList);
    }

    public static <T> ImmutableSetBuilder<T> newImmutableSetBuilder(int initialCapacity) {
        return new ImmutableSetBuilder(initialCapacity);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.state == InflatableSet.State.INFLATED) {
            throw new IllegalStateException("Set is immutable and can not be inflated.");
        }
        return new ImmutableHybridIterator();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    public static final class ImmutableSetBuilder<T>
    extends InflatableSet.AbstractBuilder<T> {
        private ImmutableSetBuilder(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public ImmutableSetBuilder<T> add(T item) {
            super.add(item);
            return this;
        }

        public ImmutableInflatableSet<T> build() {
            ImmutableInflatableSet set = new ImmutableInflatableSet(this.list);
            this.list = Collections.emptyList();
            return set;
        }
    }

    private final class ImmutableHybridIterator
    extends InflatableSet.HybridIterator {
        private ImmutableHybridIterator() {
            super(ImmutableInflatableSet.this);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

