/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.LocalDateConverter;
import org.apache.wicket.util.string.Strings;

public class LocalDateTextField
extends TextField<LocalDate>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private final TextFormatConverter converter;

    public LocalDateTextField(String id, String pattern) {
        this(id, null, pattern);
    }

    public LocalDateTextField(String id, IModel<LocalDate> model, String pattern) {
        this(id, model, pattern, pattern);
    }

    public LocalDateTextField(String id, IModel<LocalDate> model, final String formatPattern, final String parsePattern) {
        super(id, model, LocalDate.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            protected DateTimeFormatter getDateTimeFormatter() {
                return DateTimeFormatter.ofPattern(formatPattern);
            }

            public LocalDate convertToObject(String value, Locale locale) {
                TemporalAccessor temporalAccessor;
                if (Strings.isEmpty((String)value)) {
                    return null;
                }
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(parsePattern).withLocale(locale);
                try {
                    temporalAccessor = dateTimeFormatter.parse(value);
                }
                catch (DateTimeParseException ex) {
                    throw this.newConversionException("Cannot parse '" + value, value, locale);
                }
                return this.createTemporal(temporalAccessor);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return formatPattern;
            }
        };
    }

    public LocalDateTextField(String id, FormatStyle dateStyle) {
        this(id, null, dateStyle);
    }

    public LocalDateTextField(String id, IModel<LocalDate> model, final FormatStyle dateStyle) {
        super(id, model, LocalDate.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            protected DateTimeFormatter getDateTimeFormatter() {
                return DateTimeFormatter.ofLocalizedDate(dateStyle);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return DateTimeFormatterBuilder.getLocalizedDateTimePattern(dateStyle, null, IsoChronology.INSTANCE, locale);
            }
        };
    }

    protected IConverter<?> createConverter(Class<?> clazz) {
        if (LocalDate.class.isAssignableFrom(clazz)) {
            return this.converter;
        }
        return null;
    }

    public final String getTextFormat() {
        return this.converter.getTextFormat(this.getLocale());
    }

    private abstract class TextFormatConverter
    extends LocalDateConverter {
        private static final long serialVersionUID = 1L;

        private TextFormatConverter() {
        }

        public abstract String getTextFormat(Locale var1);
    }
}

