/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.xml.OutputsDOM;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.xml.Namespace;

public class TextMatch
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "text-match";
    public static final String ATTR_CASELESS = "caseless";
    public static final String ATTR_NEGATE_CONDITION = "negate-condition";
    public static final String ATTR_COLLATION = "collation";
    public static final String ATTR_VALUE_YES = "yes";
    public static final String ATTR_VALUE_NO = "no";
    public static final String ATTR_VALUE_COLLATION_ASCII = "i;ascii-casemap";
    public static final String ATTR_VALUE_COLLATION_OCT = "i;octet";
    private String collation = null;
    private String textToMatch = null;
    private Boolean caseless = null;
    private Boolean negateCondition = null;

    public TextMatch(Boolean caseless, Boolean negateCondition, String collation, String textToMatch) {
        this.caseless = caseless;
        this.negateCondition = negateCondition;
        this.textToMatch = textToMatch;
        this.collation = collation == null ? ATTR_VALUE_COLLATION_ASCII : collation;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<OutputsDOM> getChildren() {
        return null;
    }

    @Override
    protected String getTextContent() {
        return this.textToMatch;
    }

    @Override
    protected Map<String, String> getAttributes() {
        HashMap<String, String> m = new HashMap<String, String>();
        if (this.caseless != null) {
            m.put(ATTR_CASELESS, this.caseless != false ? ATTR_VALUE_YES : ATTR_VALUE_NO);
        }
        if (this.negateCondition != null && this.negateCondition.booleanValue()) {
            m.put(ATTR_NEGATE_CONDITION, this.negateCondition != false ? ATTR_VALUE_YES : ATTR_VALUE_NO);
        }
        if (this.collation != null) {
            m.put(ATTR_COLLATION, this.collation);
        }
        return m;
    }

    public Boolean getCaseless() {
        return this.caseless;
    }

    public void setCaseless(Boolean caseless) {
        this.caseless = caseless;
    }

    public String getTextToMatch() {
        return this.textToMatch;
    }

    public void setTextToMatch(String textToMatch) {
        this.textToMatch = textToMatch;
    }

    @Override
    public void validate() {
    }
}

