/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.core.windows.options;

import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

@OptionsPanelController.Keywords(keywords={"#KW_TabsOptions"}, location="Appearance", tabTitle="#Tabs_DisplayName")
public class TabsPanel extends javax.swing.JPanel {

    protected final TabsOptionsPanelController controller;

    private final Preferences prefs = NbPreferences.forModule(TabsPanel.class);

    private final boolean isAquaLaF = "Aqua".equals(UIManager.getLookAndFeel().getID()); //NOI18N

    private boolean defMultiRow;
    private int defTabPlacement;

    public enum EditorSortType {
        None,
        FileName,
        FileNameWithParent,
        FullFilePath,
    }

    protected TabsPanel(final TabsOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        initTabsPanel( panelTabs );
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        sortButtonGroup = new javax.swing.ButtonGroup();
        panelDocTabs = new javax.swing.JPanel();
        isCloseActivatesMostRecentDocument = new javax.swing.JCheckBox();
        isNewDocumentOpensNextToActiveTab = new javax.swing.JCheckBox();
        sortTabsLabel = new javax.swing.JLabel();
        radioSortNothing = new javax.swing.JRadioButton();
        radioSortFileName = new javax.swing.JRadioButton();
        radioSortFileNameWithParent = new javax.swing.JRadioButton();
        radioSortFullFilePath = new javax.swing.JRadioButton();
        panelTabs = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        radioTop = new javax.swing.JRadioButton();
        radioBottom = new javax.swing.JRadioButton();
        radioLeft = new javax.swing.JRadioButton();
        radioRight = new javax.swing.JRadioButton();
        checkMultiRow = new javax.swing.JCheckBox();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));

        panelDocTabs.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(isCloseActivatesMostRecentDocument, org.openide.util.NbBundle.getMessage(TabsPanel.class, "LBL_CloseActivatesRecentDocument")); // NOI18N
        isCloseActivatesMostRecentDocument.setToolTipText(org.openide.util.NbBundle.getMessage(TabsPanel.class, "TIP_CloseActivatesMostRecentDocument")); // NOI18N
        isCloseActivatesMostRecentDocument.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isCloseActivatesMostRecentDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        panelDocTabs.add(isCloseActivatesMostRecentDocument, gridBagConstraints);
        isCloseActivatesMostRecentDocument.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TabsPanel.class, "TabsPanel.isCloseActivatesMostRecentDocument.AccessibleContext.accessibleDescription")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(isNewDocumentOpensNextToActiveTab, NbBundle.getMessage(TabsPanel.class, "TabsPanel.isNewDocumentOpensNextToActiveTab.text")); // NOI18N
        isNewDocumentOpensNextToActiveTab.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isNewDocumentOpensNextToActiveTabActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        panelDocTabs.add(isNewDocumentOpensNextToActiveTab, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(sortTabsLabel, org.openide.util.NbBundle.getMessage(TabsPanel.class, "TabsPanel.sortTabsLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 6, 0);
        panelDocTabs.add(sortTabsLabel, gridBagConstraints);

        sortButtonGroup.add(radioSortNothing);
        radioSortNothing.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(radioSortNothing, org.openide.util.NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioSortNothing.text")); // NOI18N
        radioSortNothing.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radioSortNothingActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelDocTabs.add(radioSortNothing, gridBagConstraints);

        sortButtonGroup.add(radioSortFileName);
        org.openide.awt.Mnemonics.setLocalizedText(radioSortFileName, org.openide.util.NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioSortFileName.text")); // NOI18N
        radioSortFileName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radioSortFileNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelDocTabs.add(radioSortFileName, gridBagConstraints);

        sortButtonGroup.add(radioSortFileNameWithParent);
        org.openide.awt.Mnemonics.setLocalizedText(radioSortFileNameWithParent, org.openide.util.NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioSortFileNameWithParent.text")); // NOI18N
        radioSortFileNameWithParent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radioSortFileNameWithParentActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelDocTabs.add(radioSortFileNameWithParent, gridBagConstraints);

        sortButtonGroup.add(radioSortFullFilePath);
        org.openide.awt.Mnemonics.setLocalizedText(radioSortFullFilePath, org.openide.util.NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioSortFullFilePath.text")); // NOI18N
        radioSortFullFilePath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radioSortFullFilePathActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelDocTabs.add(radioSortFullFilePath, gridBagConstraints);

        panelTabs.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, NbBundle.getMessage(TabsPanel.class, "TabsPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 6, 0);
        panelTabs.add(jLabel1, gridBagConstraints);

        buttonGroup1.add(radioTop);
        radioTop.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(radioTop, NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioTop.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelTabs.add(radioTop, gridBagConstraints);

        buttonGroup1.add(radioBottom);
        org.openide.awt.Mnemonics.setLocalizedText(radioBottom, NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioBottom.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelTabs.add(radioBottom, gridBagConstraints);

        buttonGroup1.add(radioLeft);
        org.openide.awt.Mnemonics.setLocalizedText(radioLeft, NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioLeft.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelTabs.add(radioLeft, gridBagConstraints);

        buttonGroup1.add(radioRight);
        org.openide.awt.Mnemonics.setLocalizedText(radioRight, NbBundle.getMessage(TabsPanel.class, "TabsPanel.radioRight.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        panelTabs.add(radioRight, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(checkMultiRow, NbBundle.getMessage(TabsPanel.class, "TabsPanel.checkMultiRow.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        panelTabs.add(checkMultiRow, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panelDocTabs.add(panelTabs, gridBagConstraints);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(panelDocTabs, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(panelDocTabs, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void isNewDocumentOpensNextToActiveTabActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isNewDocumentOpensNextToActiveTabActionPerformed
        fireChanged();
    }//GEN-LAST:event_isNewDocumentOpensNextToActiveTabActionPerformed

    private void isCloseActivatesMostRecentDocumentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isCloseActivatesMostRecentDocumentActionPerformed
        fireChanged();
    }//GEN-LAST:event_isCloseActivatesMostRecentDocumentActionPerformed

    private void radioSortNothingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radioSortNothingActionPerformed
        fireChanged();
    }//GEN-LAST:event_radioSortNothingActionPerformed

    private void radioSortFileNameWithParentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radioSortFileNameWithParentActionPerformed
        fireChanged();
    }//GEN-LAST:event_radioSortFileNameWithParentActionPerformed

    private void radioSortFullFilePathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radioSortFullFilePathActionPerformed
        fireChanged();
    }//GEN-LAST:event_radioSortFullFilePathActionPerformed

    private void radioSortFileNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radioSortFileNameActionPerformed
        fireChanged();
    }//GEN-LAST:event_radioSortFileNameActionPerformed

    private void fireChanged() {
        boolean isChanged = false;
        if(isCloseActivatesMostRecentDocument.isSelected() != prefs.getBoolean(WinSysPrefs.EDITOR_CLOSE_ACTIVATES_RECENT, true)
                || isNewDocumentOpensNextToActiveTab.isSelected() != prefs.getBoolean(WinSysPrefs.OPEN_DOCUMENTS_NEXT_TO_ACTIVE_TAB, false)
                || getSelectedSortType() != EditorSortType.valueOf(prefs.get(WinSysPrefs.EDITOR_SORT_TABS, EditorSortType.None.name()))) {
            isChanged = true;
        }
        controller.changed(isChanged, null);
    }

    protected void load() {
        isCloseActivatesMostRecentDocument.setSelected(prefs.getBoolean(WinSysPrefs.EDITOR_CLOSE_ACTIVATES_RECENT, true));
        isNewDocumentOpensNextToActiveTab.setSelected(prefs.getBoolean(WinSysPrefs.OPEN_DOCUMENTS_NEXT_TO_ACTIVE_TAB, false));
        EditorSortType sortType = EditorSortType.valueOf(prefs.get(WinSysPrefs.EDITOR_SORT_TABS, EditorSortType.None.name()));
        switch (sortType) {
            case FullFilePath:
                radioSortFullFilePath.setSelected(true);
                break;
            case FileName:
                radioSortFileName.setSelected(true);
                break;
            case FileNameWithParent:
                radioSortFileNameWithParent.setSelected(true);
                break;
            default:
                radioSortNothing.setSelected(true);
                break;
        }

        defMultiRow = prefs.getBoolean( WinSysPrefs.DOCUMENT_TABS_MULTIROW, false );
        checkMultiRow.setSelected( defMultiRow );
        defTabPlacement = prefs.getInt( WinSysPrefs.DOCUMENT_TABS_PLACEMENT, JTabbedPane.TOP );
        switch( defTabPlacement ) {
            case JTabbedPane.BOTTOM:
                radioBottom.setSelected( true );
                break;
            case JTabbedPane.LEFT:
                radioLeft.setSelected( true );
                break;
            case JTabbedPane.RIGHT:
                radioRight.setSelected( true );
                break;
            default:
                radioTop.setSelected( true );
        }

        if( isAquaLaF ) {
            checkMultiRow.setSelected(false);
            checkMultiRow.setEnabled(false);
            radioLeft.setEnabled(false);
            radioRight.setEnabled(false);
            if( radioLeft.isSelected() || radioRight.isSelected() ) {
                radioTop.setSelected(true);
            }
        }
    }

    protected boolean store() {
        prefs.putBoolean(WinSysPrefs.EDITOR_CLOSE_ACTIVATES_RECENT, isCloseActivatesMostRecentDocument.isSelected());
        prefs.putBoolean(WinSysPrefs.OPEN_DOCUMENTS_NEXT_TO_ACTIVE_TAB, isNewDocumentOpensNextToActiveTab.isSelected());
        prefs.put(WinSysPrefs.EDITOR_SORT_TABS, getSelectedSortType().name());

        boolean needsWinsysRefresh = false;
        needsWinsysRefresh = checkMultiRow.isSelected() != defMultiRow;
        prefs.putBoolean(WinSysPrefs.DOCUMENT_TABS_MULTIROW, checkMultiRow.isSelected());

        int tabPlacement = JTabbedPane.TOP;
        if( radioBottom.isSelected() )
            tabPlacement = JTabbedPane.BOTTOM;
        else if( radioLeft.isSelected() )
            tabPlacement = JTabbedPane.LEFT;
        else if( radioRight.isSelected() )
            tabPlacement = JTabbedPane.RIGHT;
        prefs.putInt( WinSysPrefs.DOCUMENT_TABS_PLACEMENT, tabPlacement );
        needsWinsysRefresh |= tabPlacement != defTabPlacement;

        return needsWinsysRefresh;
    }

    private EditorSortType getSelectedSortType() {
        EditorSortType sortType = EditorSortType.None;
        if (radioSortFullFilePath.isSelected()) {
            sortType = EditorSortType.FullFilePath;
        } else if (radioSortFileName.isSelected()) {
            sortType = EditorSortType.FileName;
        } else if (radioSortFileNameWithParent.isSelected()) {
            sortType = EditorSortType.FileNameWithParent;
        }
        return sortType;
    }

    boolean valid() {
        // TODO check whether form is consistent and complete
        return true;
    }

    protected void initTabsPanel( JPanel panel ) {

    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox checkMultiRow;
    private javax.swing.JCheckBox isCloseActivatesMostRecentDocument;
    private javax.swing.JCheckBox isNewDocumentOpensNextToActiveTab;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel panelDocTabs;
    private javax.swing.JPanel panelTabs;
    private javax.swing.JRadioButton radioBottom;
    private javax.swing.JRadioButton radioLeft;
    private javax.swing.JRadioButton radioRight;
    private javax.swing.JRadioButton radioSortFileName;
    private javax.swing.JRadioButton radioSortFileNameWithParent;
    private javax.swing.JRadioButton radioSortFullFilePath;
    private javax.swing.JRadioButton radioSortNothing;
    private javax.swing.JRadioButton radioTop;
    private javax.swing.ButtonGroup sortButtonGroup;
    private javax.swing.JLabel sortTabsLabel;
    // End of variables declaration//GEN-END:variables

}
