/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.EventQueue;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RenameAction
extends NodeAction {
    private static final RequestProcessor RP = new RequestProcessor(RenameAction.class);

    @Override
    protected boolean surviveFocusChange() {
        return false;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(RenameAction.class, "Rename");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(RenameAction.class);
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0].canRename();
    }

    @Override
    protected void performAction(final Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return;
        }
        Node n = activatedNodes[0];
        if (EventQueue.isDispatchThread() && Boolean.TRUE.equals(n.getValue("slowRename"))) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    RenameAction.this.performAction(activatedNodes);
                }
            });
            return;
        }
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameAction.class, "CTL_RenameLabel"), NbBundle.getMessage(RenameAction.class, "CTL_RenameTitle"));
        dlg.setInputText(n.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify(dlg))) {
            String newname = null;
            try {
                newname = dlg.getInputText();
                if (!newname.equals("")) {
                    n.setName(dlg.getInputText());
                }
            }
            catch (IllegalArgumentException e) {
                boolean needToAnnotate;
                boolean bl = needToAnnotate = Exceptions.findLocalizedMessage(e) == null;
                if (needToAnnotate) {
                    Exceptions.attachLocalizedMessage(e, NbBundle.getMessage(RenameAction.class, "MSG_BadFormat", n.getName(), newname));
                }
                Exceptions.printStackTrace(e);
            }
        }
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }
}

