/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.elasticsearch;

import org.elasticsearch.common.settings.Settings;

public class MCFConfigurationParameters {
    public String authorityServiceBaseURL = "http://localhost:8345/mcf-authority-service";
    public int connectionTimeout = 60000;
    public int socketTimeout = 300000;
    public String allowFieldPrefix = "allow_token_";
    public String denyFieldPrefix = "deny_token_";
    public int connectionPoolSize = 50;

    public MCFConfigurationParameters() {
    }

    public MCFConfigurationParameters(Settings settings) {
        this.setBaseURL(settings.get("mcf.authority_service_base_url", this.authorityServiceBaseURL));
        this.setConnectionTimeout(settings.getAsInt("mcf.http.connection_timeout", Integer.valueOf(this.connectionTimeout)));
        this.setSocketTimeout(settings.getAsInt("mcf.http.socket_timeout", Integer.valueOf(this.socketTimeout)));
        this.setAllowFieldPrefix(settings.get("mcf.allow_field_prefix", this.allowFieldPrefix));
        this.setDenyFieldPrefix(settings.get("mcf.deny_field_prefix", this.denyFieldPrefix));
        this.setConnectionPoolSize(settings.getAsInt("mcf.http.connection_pool_size", Integer.valueOf(this.connectionPoolSize)));
    }

    public MCFConfigurationParameters setBaseURL(String baseURL) {
        this.authorityServiceBaseURL = baseURL;
        return this;
    }

    public MCFConfigurationParameters setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
        return this;
    }

    public MCFConfigurationParameters setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
        return this;
    }

    public MCFConfigurationParameters setAllowFieldPrefix(String prefix) {
        this.allowFieldPrefix = prefix;
        return this;
    }

    public MCFConfigurationParameters setDenyFieldPrefix(String prefix) {
        this.denyFieldPrefix = prefix;
        return this;
    }

    public MCFConfigurationParameters setConnectionPoolSize(int size) {
        this.connectionPoolSize = size;
        return this;
    }
}

