/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.util.RolloverSignerSecretProvider;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class RandomSignerSecretProvider
extends RolloverSignerSecretProvider {
    private final Random rand;

    public RandomSignerSecretProvider() {
        this.rand = new Random();
    }

    @VisibleForTesting
    public RandomSignerSecretProvider(long seed) {
        this.rand = new Random(seed);
    }

    @Override
    protected byte[] generateNewSecret() {
        return Long.toString(this.rand.nextLong()).getBytes();
    }
}

