/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.math.Varint;

public class VarLongWritable
implements WritableComparable<VarLongWritable> {
    private long value;

    public VarLongWritable() {
    }

    public VarLongWritable(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    public void set(long value) {
        this.value = value;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass()) && ((VarLongWritable)other).value == this.value;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int compareTo(VarLongWritable other) {
        if (this.value >= other.value) {
            if (this.value > other.value) {
                return 1;
            }
        } else {
            return -1;
        }
        return 0;
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarLong(this.value, out);
    }

    public void readFields(DataInput in) throws IOException {
        this.value = Varint.readSignedVarLong(in);
    }
}

