/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborQueue;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

abstract class AbstractHnswGraphSearcher {
    static final int UNK_EP = -1;

    AbstractHnswGraphSearcher() {
    }

    abstract void searchLevel(KnnCollector var1, RandomVectorScorer var2, int var3, int[] var4, HnswGraph var5, Bits var6) throws IOException;

    abstract int[] findBestEntryPoint(RandomVectorScorer var1, HnswGraph var2, KnnCollector var3) throws IOException;

    public void search(KnnCollector results, RandomVectorScorer scorer, HnswGraph graph, Bits acceptOrds) throws IOException {
        int[] eps = this.findBestEntryPoint(scorer, graph, results);
        assert (eps != null && eps.length > 0);
        if (eps[0] == -1) {
            return;
        }
        this.searchLevel(results, scorer, 0, eps, graph, acceptOrds);
    }

    protected static void scoreEntryPoints(KnnCollector results, RandomVectorScorer scorer, BitSet visited, int[] eps, Bits acceptOrds, NeighborQueue candidates, float[] scores) throws IOException {
        assert (eps != null && eps.length > 0);
        assert (scores != null && scores.length >= eps.length);
        scorer.bulkScore(eps, scores, eps.length);
        results.incVisitedCount(eps.length);
        for (int i = 0; i < eps.length; ++i) {
            float score = scores[i];
            int ep = eps[i];
            visited.set(ep);
            candidates.add(ep, score);
            if (acceptOrds != null && !acceptOrds.get(ep)) continue;
            results.collect(ep, score);
        }
    }
}

