/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene99;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.backward_codecs.lucene99.OffHeapQuantizedByteVectorValues;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.quantization.ScalarQuantizer;

abstract class OffHeapQuantizedFloatVectorValues
extends FloatVectorValues
implements HasIndexSlice {
    protected final int dimension;
    protected final int size;
    protected final int numBytes;
    protected final ScalarQuantizer scalarQuantizer;
    protected final VectorSimilarityFunction similarityFunction;
    protected final FlatVectorsScorer vectorsScorer;
    protected final boolean compress;
    protected final IndexInput slice;
    protected final float[] floatValue;
    protected final byte[] binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;
    protected int curOrd = -1;
    protected final float[] scoreCorrectionConstant = new float[1];

    OffHeapQuantizedFloatVectorValues(int dimension, int size, ScalarQuantizer scalarQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, boolean compress, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.scalarQuantizer = scalarQuantizer;
        this.compress = compress;
        this.numBytes = scalarQuantizer.getBits() <= 4 && compress ? dimension + 1 >> 1 : dimension;
        this.byteSize = this.numBytes + 4;
        this.byteBuffer = ByteBuffer.allocate(dimension);
        this.binaryValue = this.byteBuffer.array();
        this.floatValue = new float[dimension];
        this.similarityFunction = similarityFunction;
        this.vectorsScorer = vectorsScorer;
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.size;
    }

    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.curOrd == targetOrd) {
            return this.floatValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.numBytes);
        this.slice.readFloats(this.scoreCorrectionConstant, 0, 1);
        OffHeapQuantizedByteVectorValues.decompressBytes(this.binaryValue, this.numBytes);
        this.scalarQuantizer.deQuantize(this.binaryValue, this.floatValue);
        this.curOrd = targetOrd;
        return this.floatValue;
    }

    public IndexInput getSlice() {
        return this.slice;
    }

    public int getVectorByteLength() {
        return this.numBytes;
    }

    public static OffHeapQuantizedFloatVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, ScalarQuantizer scalarQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, boolean compress, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (size == 0) {
            return new EmptyOffHeapVectorValues(dimension, similarityFunction, vectorsScorer);
        }
        IndexInput bytesSlice = vectorData.slice("quantized-float-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, scalarQuantizer, compress, similarityFunction, vectorsScorer, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, scalarQuantizer, compress, vectorData, similarityFunction, vectorsScorer, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapQuantizedFloatVectorValues {
        public EmptyOffHeapVectorValues(int dimension, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer) {
            super(dimension, 0, new ScalarQuantizer(-1.0f, 1.0f, 7), similarityFunction, vectorsScorer, false, null);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        public EmptyOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) {
            throw new UnsupportedOperationException();
        }

        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        public VectorScorer scorer(float[] target) {
            return null;
        }
    }

    private static class DenseOffHeapVectorValues
    extends OffHeapQuantizedFloatVectorValues {
        public DenseOffHeapVectorValues(int dimension, int size, ScalarQuantizer scalarQuantizer, boolean compress, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(dimension, size, scalarQuantizer, similarityFunction, vectorsScorer, compress, slice);
        }

        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.scalarQuantizer, this.compress, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        public VectorScorer scorer(float[] target) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer vectorScorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return vectorScorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapQuantizedFloatVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        public SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, ScalarQuantizer scalarQuantizer, boolean compress, IndexInput dataIn, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) throws IOException {
            super(dimension, size, scalarQuantizer, similarityFunction, vectorsScorer, compress, slice);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator((IndexedDISI)this.disi);
        }

        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.scalarQuantizer, this.compress, this.dataIn, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get((long)ord);
        }

        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                public int length() {
                    return size;
                }
            };
        }

        public VectorScorer scorer(float[] target) throws IOException {
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer vectorScorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return vectorScorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

