/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.stemmer.snowball;

import java.lang.reflect.InvocationTargetException;
import opennlp.tools.stemmer.snowball.Among;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnowballProgram {
    private static final Logger logger = LoggerFactory.getLogger(SnowballProgram.class);
    protected StringBuilder current;
    protected int cursor;
    protected int limit;
    protected int limit_backward;
    protected int bra;
    protected int ket;

    protected SnowballProgram() {
        this.current = new StringBuilder();
        this.init();
    }

    public SnowballProgram(SnowballProgram other) {
        this.current = other.current;
        this.cursor = other.cursor;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    private void init() {
        this.cursor = 0;
        this.limit = this.current.length();
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    public String getCurrent() {
        return this.current.toString();
    }

    public void setCurrent(String value) {
        this.current = new StringBuilder(value);
        this.init();
    }

    protected void copy_from(SnowballProgram other) {
        this.current = other.current;
        this.cursor = other.cursor;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    protected boolean in_grouping(char[] s, int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current.charAt(this.cursor);
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_grouping_b(char[] s, int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current.charAt(this.cursor - 1);
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_grouping(char[] s, int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current.charAt(this.cursor);
        if (ch > max || ch < min) {
            ++this.cursor;
            return true;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    protected boolean out_grouping_b(char[] s, int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current.charAt(this.cursor - 1);
        if (ch > max || ch < min) {
            --this.cursor;
            return true;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            --this.cursor;
            return true;
        }
        return false;
    }

    protected boolean eq_s(CharSequence s) {
        if (this.limit - this.cursor < s.length()) {
            return false;
        }
        for (int i = 0; i != s.length(); ++i) {
            if (this.current.charAt(this.cursor + i) == s.charAt(i)) continue;
            return false;
        }
        this.cursor += s.length();
        return true;
    }

    protected boolean eq_s_b(CharSequence s) {
        if (this.cursor - this.limit_backward < s.length()) {
            return false;
        }
        for (int i = 0; i != s.length(); ++i) {
            if (this.current.charAt(this.cursor - s.length() + i) == s.charAt(i)) continue;
            return false;
        }
        this.cursor -= s.length();
        return true;
    }

    protected int find_among(Among[] v) {
        Among w;
        int i = 0;
        int j = v.length;
        int c = this.cursor;
        int l = this.limit;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = common; i2 < w2.s.length; ++i2) {
                if (c + common == l) {
                    diff = -1;
                    break;
                }
                diff = this.current.charAt(c + common) - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            boolean res;
            w = v[i];
            if (common_i < w.s.length) continue;
            this.cursor = c + w.s.length;
            if (w.method == null) {
                return w.result;
            }
            try {
                Object resobj = w.method.invoke((Object)this, new Object[0]);
                res = resobj.toString().equals("true");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                res = false;
                logger.warn(e.getLocalizedMessage(), e);
            }
            this.cursor = c + w.s.length;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int find_among_b(Among[] v) {
        Among w;
        int i = 0;
        int j = v.length;
        int c = this.cursor;
        int lb = this.limit_backward;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = w2.s.length - 1 - common; i2 >= 0; --i2) {
                if (c - common == lb) {
                    diff = -1;
                    break;
                }
                diff = this.current.charAt(c - 1 - common) - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            boolean res;
            w = v[i];
            if (common_i < w.s.length) continue;
            this.cursor = c - w.s.length;
            if (w.method == null) {
                return w.result;
            }
            try {
                Object resobj = w.method.invoke((Object)this, new Object[0]);
                res = resobj.toString().equals("true");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                res = false;
                logger.warn("Triggered by {}. Exception: {}", this.current, e.getLocalizedMessage(), e);
            }
            this.cursor = c - w.s.length;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int replace_s(int c_bra, int c_ket, String s) {
        int adjustment = s.length() - (c_ket - c_bra);
        this.current.replace(c_bra, c_ket, s);
        this.limit += adjustment;
        if (this.cursor >= c_ket) {
            this.cursor += adjustment;
        } else if (this.cursor > c_bra) {
            this.cursor = c_bra;
        }
        return adjustment;
    }

    protected void slice_check() {
        if (this.bra < 0 || this.bra > this.ket || this.ket > this.limit || this.limit > this.current.length()) {
            logger.error("faulty slice operation");
        }
    }

    protected void slice_from(String s) {
        this.slice_check();
        this.replace_s(this.bra, this.ket, s);
    }

    protected void slice_from(CharSequence s) {
        this.slice_from(s.toString());
    }

    protected void slice_del() {
        this.slice_from("");
    }

    protected void insert(int c_bra, int c_ket, String s) {
        int adjustment = this.replace_s(c_bra, c_ket, s);
        if (c_bra <= this.bra) {
            this.bra += adjustment;
        }
        if (c_bra <= this.ket) {
            this.ket += adjustment;
        }
    }

    protected void insert(int c_bra, int c_ket, CharSequence s) {
        this.insert(c_bra, c_ket, s.toString());
    }

    protected void slice_to(StringBuilder s) {
        this.slice_check();
        s.replace(0, s.length(), this.current.substring(this.bra, this.ket));
    }
}

