/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.query.exception.UserStopQueryException;
import org.apache.kylin.query.util.SlowQueryDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInterruptChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryInterruptChecker.class);

    private QueryInterruptChecker() {
    }

    public static void checkThreadInterrupted(String errorMsgLog, String stepInfo) {
        if (Thread.currentThread().isInterrupted()) {
            log.error("{} {}", (Object)QueryContext.current().getQueryId(), (Object)errorMsgLog);
            if (SlowQueryDetector.getRunningQueries().containsKey(Thread.currentThread()) && SlowQueryDetector.getRunningQueries().get(Thread.currentThread()).isStopByUser()) {
                throw new UserStopQueryException("");
            }
            if (QueryContext.current().getQueryTagInfo().isErrInterrupted()) {
                throw new KylinRuntimeException(QueryContext.current().getQueryTagInfo().getInterruptReason());
            }
            QueryContext.current().getQueryTagInfo().setTimeout(true);
            throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. " + stepInfo);
        }
    }

    public static void checkQueryCanceledOrThreadInterrupted(String cause, String step) throws InterruptedException {
        SlowQueryDetector.QueryEntry entry = SlowQueryDetector.getRunningQueries().getOrDefault(Thread.currentThread(), null);
        if (entry != null) {
            if (entry.isStopByUser() && entry.getPlannerCancelFlag().isCancelRequested() && Thread.currentThread().isInterrupted()) {
                throw new UserStopQueryException(String.format(Locale.ROOT, "Manually stop the query %s. Caused: %s. Step: %s", entry.getQueryId(), cause, step));
            }
            if (entry.getPlannerCancelFlag().isCancelRequested() && entry.isTimeoutStop) {
                QueryContext.current().getQueryTagInfo().setTimeout(true);
                throw new KylinTimeoutException(String.format(Locale.ROOT, "Run out of time of the query %s. Caused: %s. Step: %s", entry.getQueryId(), cause, step));
            }
            if (entry.isStopByUser() || entry.getPlannerCancelFlag().isCancelRequested()) {
                throw new UserStopQueryException(String.format(Locale.ROOT, "You are trying to cancel the query %s with inconsistent states: [isStopByUser=%s, isCancelRequested=%s]! Caused: %s. Step: %s", entry.getQueryId(), entry.isStopByUser(), entry.getPlannerCancelFlag().isCancelRequested(), cause, step));
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(String.format(Locale.ROOT, "Interrupted on thread %s. Caused: %s. Step: %s", Thread.currentThread().getName(), cause, step));
        }
    }
}

