/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryInfo;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class AccelerateRuleUtil {
    public List<QueryHistory> findMatchedCandidate(String project, List<QueryHistory> queryHistories, Map<String, Set<String>> submitterToGroups, List<Pair<Long, QueryHistoryInfo>> batchArgs) {
        ArrayList candidate = Lists.newArrayList();
        for (QueryHistory qh : queryHistories) {
            QueryHistoryInfo queryHistoryInfo = qh.getQueryHistoryInfo();
            if (queryHistoryInfo == null) continue;
            if (this.matchCustomerRule(qh, project, submitterToGroups) && this.matchInternalRule(qh)) {
                queryHistoryInfo.setState(QueryHistoryInfo.HistoryState.SUCCESS);
                candidate.add(qh);
            } else {
                queryHistoryInfo.setState(QueryHistoryInfo.HistoryState.FAILED);
            }
            batchArgs.add((Pair<Long, QueryHistoryInfo>)new Pair((Object)qh.getId(), (Object)queryHistoryInfo));
        }
        return candidate;
    }

    private boolean matchInternalRule(QueryHistory queryHistory) {
        if (queryHistory.getQueryHistoryInfo() == null) {
            return false;
        }
        return InternalBlackOutRule.getSingletonInstance().filterCannotAccelerate(queryHistory);
    }

    public boolean matchCustomerRule(QueryHistory queryHistory, String project, Map<String, Set<String>> submitterToGroups) {
        FavoriteRule submitterRule = FavoriteRuleManager.getInstance(project).getOrDefaultByName("submitter");
        boolean submitterMatch = this.matchRule(queryHistory, submitterRule, (queryHistory1, conditions) -> conditions.stream().anyMatch(cond -> queryHistory1.getQuerySubmitter().equals(((FavoriteRule.Condition)cond).getRightThreshold())));
        FavoriteRule groupRule = FavoriteRuleManager.getInstance(project).getOrDefaultByName("submitter_group");
        boolean userGroupMatch = this.matchRule(queryHistory, groupRule, (queryHistory1, conditions) -> conditions.stream().anyMatch(cond -> submitterToGroups.computeIfAbsent(queryHistory1.getQuerySubmitter(), key -> new HashSet()).contains(((FavoriteRule.Condition)cond).getRightThreshold())));
        FavoriteRule durationRule = FavoriteRuleManager.getInstance(project).getOrDefaultByName("duration");
        boolean durationMatch = this.matchRule(queryHistory, durationRule, (queryHistory1, conditions) -> conditions.stream().anyMatch(cond -> queryHistory1.getDuration() >= Long.parseLong(((FavoriteRule.Condition)cond).getLeftThreshold()) * 1000L && queryHistory1.getDuration() <= Long.parseLong(((FavoriteRule.Condition)cond).getRightThreshold()) * 1000L));
        return (submitterMatch || userGroupMatch) && durationMatch;
    }

    private boolean matchRule(QueryHistory history, FavoriteRule favoriteRule, BiPredicate<QueryHistory, List<?>> function) {
        if (("submitter".equals(favoriteRule.getName()) || "submitter_group".equals(favoriteRule.getName())) && !favoriteRule.isEnabled()) {
            return true;
        }
        return function.test(history, favoriteRule.getConds());
    }

    static class InternalBlackOutRule {
        private static InternalBlackOutRule instance;

        public static synchronized InternalBlackOutRule getSingletonInstance() {
            if (instance == null) {
                instance = new InternalBlackOutRule();
            }
            return instance;
        }

        private InternalBlackOutRule() {
        }

        public boolean filterCannotAccelerate(QueryHistory queryHistory) {
            return !this.exactlyMatchedQuery(queryHistory) && !this.pushdownForExecutionError(queryHistory);
        }

        private boolean exactlyMatchedQuery(QueryHistory queryHistory) {
            return queryHistory.getQueryHistoryInfo().isExactlyMatch();
        }

        private boolean pushdownForExecutionError(QueryHistory queryHistory) {
            return queryHistory.getQueryHistoryInfo().isExecutionError();
        }
    }
}

