/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidStatsUtil {
    private static final Logger logger = LoggerFactory.getLogger(CuboidStatsUtil.class);

    private CuboidStatsUtil() {
        throw new IllegalStateException("Class CuboidStatsUtil is an utility class !");
    }

    public static Map<BigInteger, Double> calculateCuboidHitProbability(Set<BigInteger> selectionCuboidSet, Map<BigInteger, Long> hitFrequencyMap, BigInteger nTotalCuboids, double queryUncertaintyRatio) {
        HashMap cuboidHitProbabilityMap = Maps.newHashMapWithExpectedSize((int)selectionCuboidSet.size());
        if (hitFrequencyMap == null || hitFrequencyMap.isEmpty()) {
            double value = BigDecimal.valueOf(1.0).divide(new BigDecimal(nTotalCuboids), 15, 6).doubleValue();
            for (BigInteger cuboid : selectionCuboidSet) {
                cuboidHitProbabilityMap.put(cuboid, value);
            }
        } else {
            long totalHitFrequency = 0L;
            for (Map.Entry<BigInteger, Long> hitFrequency : hitFrequencyMap.entrySet()) {
                totalHitFrequency += hitFrequency.getValue().longValue();
            }
            double unitUncertainProb = BigDecimal.valueOf(queryUncertaintyRatio).divide(new BigDecimal(nTotalCuboids), 15, 6).doubleValue();
            for (BigInteger cuboid : selectionCuboidSet) {
                if (hitFrequencyMap.get(cuboid) != null) {
                    if (totalHitFrequency != 0L) {
                        cuboidHitProbabilityMap.put(cuboid, unitUncertainProb + (1.0 - queryUncertaintyRatio) * (double)hitFrequencyMap.get(cuboid).longValue() / (double)totalHitFrequency);
                        continue;
                    }
                    throw new ArithmeticException("/ by zero");
                }
                cuboidHitProbabilityMap.put(cuboid, unitUncertainProb);
            }
        }
        return cuboidHitProbabilityMap;
    }

    public static Map<BigInteger, Long> generateSourceCuboidStats(Map<BigInteger, Long> statistics, Map<BigInteger, Double> cuboidHitProbabilityMap, Map<BigInteger, Map<BigInteger, Pair<Long, Long>>> rollingUpSourceMap) {
        HashMap srcCuboidsStats = Maps.newHashMap();
        if (cuboidHitProbabilityMap == null || cuboidHitProbabilityMap.isEmpty() || rollingUpSourceMap == null || rollingUpSourceMap.isEmpty()) {
            return srcCuboidsStats;
        }
        for (BigInteger cuboid : cuboidHitProbabilityMap.keySet()) {
            Map<BigInteger, Pair<Long, Long>> innerRollingUpTargetMap;
            if (statistics.get(cuboid) != null || (innerRollingUpTargetMap = rollingUpSourceMap.get(cuboid)) == null || innerRollingUpTargetMap.isEmpty()) continue;
            long totalEstRowCount = 0L;
            int nEffective = 0;
            boolean ifHasStats = false;
            for (BigInteger tgtCuboid : innerRollingUpTargetMap.keySet()) {
                Pair<Long, Long> rollingupStats = innerRollingUpTargetMap.get(tgtCuboid);
                if (statistics.get(tgtCuboid) != null) {
                    if (!ifHasStats) {
                        totalEstRowCount = 0L;
                        nEffective = 0;
                        ifHasStats = true;
                    }
                    double rollupRatio = CuboidStatsUtil.calculateRollupRatio(rollingupStats);
                    totalEstRowCount = (long)((double)totalEstRowCount + (1.0 - rollupRatio) * (double)statistics.get(tgtCuboid).longValue());
                    ++nEffective;
                    continue;
                }
                if (ifHasStats) continue;
                totalEstRowCount += ((Long)rollingupStats.getSecond()).longValue();
                ++nEffective;
            }
            if (nEffective != 0) {
                srcCuboidsStats.put(cuboid, totalEstRowCount / (long)nEffective);
                continue;
            }
            throw new ArithmeticException("/ by zero");
        }
        srcCuboidsStats.remove(BigInteger.ZERO);
        CuboidStatsUtil.adjustCuboidStats(srcCuboidsStats, statistics);
        return srcCuboidsStats;
    }

    public static Map<BigInteger, Long> complementRowCountForCuboids(Map<BigInteger, Long> statistics, Set<BigInteger> cuboids) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)cuboids.size());
        TreeSet<Map.Entry<BigInteger, Long>> sortedStatsSet = new TreeSet<Map.Entry<BigInteger, Long>>(new Comparator<Map.Entry<BigInteger, Long>>(){

            @Override
            public int compare(Map.Entry<BigInteger, Long> o1, Map.Entry<BigInteger, Long> o2) {
                int ret = o1.getValue().compareTo(o2.getValue());
                return ret == 0 ? o1.getKey().compareTo(o2.getKey()) : ret;
            }
        });
        for (Map.Entry<BigInteger, Long> entry : statistics.entrySet()) {
            sortedStatsSet.add(entry);
        }
        block1: for (BigInteger cuboid : cuboids) {
            if (statistics.get(cuboid) == null) {
                for (Map.Entry entry : sortedStatsSet) {
                    if (!CuboidStatsUtil.isDescendant(cuboid, (BigInteger)entry.getKey())) continue;
                    result.put(cuboid, entry.getValue());
                    continue block1;
                }
                continue;
            }
            result.put(cuboid, statistics.get(cuboid));
        }
        return result;
    }

    public static Map<BigInteger, Long> adjustCuboidStats(Map<BigInteger, Long> statistics) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)statistics.size());
        ArrayList cuboids = Lists.newArrayList(statistics.keySet());
        Collections.sort(cuboids);
        for (BigInteger cuboid : cuboids) {
            Long rowCount = statistics.get(cuboid);
            for (BigInteger childCuboid : ret.keySet()) {
                if (!CuboidStatsUtil.isDescendant(childCuboid, cuboid)) continue;
                Long childRowCount = (Long)ret.get(childCuboid);
                if (rowCount >= childRowCount) continue;
                rowCount = childRowCount;
            }
            ret.put(cuboid, rowCount);
        }
        return ret;
    }

    public static void adjustCuboidStats(Map<BigInteger, Long> mandatoryCuboidsWithStats, Map<BigInteger, Long> statistics) {
        ArrayList mandatoryCuboids = Lists.newArrayList(mandatoryCuboidsWithStats.keySet());
        Collections.sort(mandatoryCuboids);
        ArrayList selectedCuboids = Lists.newArrayList(statistics.keySet());
        Collections.sort(selectedCuboids);
        for (int i = 0; i < mandatoryCuboids.size(); ++i) {
            BigInteger sCuboid;
            int k;
            BigInteger mCuboid = (BigInteger)mandatoryCuboids.get(i);
            if (statistics.get(mCuboid) != null) {
                mandatoryCuboidsWithStats.put(mCuboid, statistics.get(mCuboid));
                continue;
            }
            for (k = 0; k < selectedCuboids.size() && (sCuboid = (BigInteger)selectedCuboids.get(k)).compareTo(mCuboid) <= 0; ++k) {
                Long childRowCount;
                if (!CuboidStatsUtil.isDescendant(sCuboid, mCuboid) || (childRowCount = statistics.get(sCuboid)) <= mandatoryCuboidsWithStats.get(mCuboid)) continue;
                mandatoryCuboidsWithStats.put(mCuboid, childRowCount);
            }
            for (int j = 0; j < i; ++j) {
                Long childRowCount;
                BigInteger cCuboid = (BigInteger)mandatoryCuboids.get(j);
                if (!CuboidStatsUtil.isDescendant(cCuboid, mCuboid) || (childRowCount = mandatoryCuboidsWithStats.get(cCuboid)) <= mandatoryCuboidsWithStats.get(mCuboid)) continue;
                mandatoryCuboidsWithStats.put(mCuboid, childRowCount);
            }
            while (k < selectedCuboids.size()) {
                Long parentRowCount;
                BigInteger sCuboid2 = (BigInteger)selectedCuboids.get(k);
                if (CuboidStatsUtil.isDescendant(mCuboid, sCuboid2) && (parentRowCount = statistics.get(sCuboid2)) < mandatoryCuboidsWithStats.get(mCuboid)) {
                    mandatoryCuboidsWithStats.put(mCuboid, parentRowCount);
                }
                ++k;
            }
        }
    }

    public static Map<BigInteger, List<BigInteger>> createDirectChildrenCache(Set<BigInteger> cuboidSet) {
        final ArrayList cuboidList = Lists.newArrayList(cuboidSet);
        Collections.sort(cuboidList);
        ArrayList layerIdxList = Lists.newArrayListWithExpectedSize((int)cuboidList.size());
        for (int i = 0; i < cuboidList.size(); ++i) {
            layerIdxList.add(i);
        }
        Collections.sort(layerIdxList, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                BigInteger o1 = (BigInteger)cuboidList.get(i1);
                BigInteger o2 = (BigInteger)cuboidList.get(i2);
                int nBitDiff = o1.bitCount() - o2.bitCount();
                if (nBitDiff != 0) {
                    return nBitDiff;
                }
                return o1.compareTo(o2);
            }
        });
        int[] toLayerIdxArray = new int[layerIdxList.size()];
        ArrayList layerCuboidList = Lists.newArrayListWithExpectedSize((int)cuboidList.size());
        int i = 0;
        while (i < layerIdxList.size()) {
            int cuboidIdx = (Integer)layerIdxList.get(i);
            toLayerIdxArray[cuboidIdx] = i++;
            layerCuboidList.add(cuboidList.get(cuboidIdx));
        }
        int[] previousLayerLastIdxArray = new int[layerIdxList.size()];
        int currentBitCount = 0;
        int previousLayerLastIdx = -1;
        for (int i2 = 0; i2 < layerIdxList.size(); ++i2) {
            int cuboidIdx = (Integer)layerIdxList.get(i2);
            int nBits = ((BigInteger)cuboidList.get(cuboidIdx)).bitCount();
            if (nBits > currentBitCount) {
                currentBitCount = nBits;
                previousLayerLastIdx = i2 - 1;
            }
            previousLayerLastIdxArray[i2] = previousLayerLastIdx;
        }
        HashMap directChildrenCache = Maps.newHashMap();
        for (int i3 = 0; i3 < cuboidList.size(); ++i3) {
            int j;
            BigInteger currentCuboid = (BigInteger)cuboidList.get(i3);
            LinkedList directChildren = Lists.newLinkedList();
            int lastLayerIdx = previousLayerLastIdxArray[toLayerIdxArray[i3]];
            if (i3 - 1 <= lastLayerIdx) {
                for (j = i3 - 1; j >= 0; --j) {
                    CuboidStatsUtil.checkAndAddDirectChild(directChildren, currentCuboid, (BigInteger)cuboidList.get(j));
                }
            } else {
                for (j = lastLayerIdx; j >= 0; --j) {
                    CuboidStatsUtil.checkAndAddDirectChild(directChildren, currentCuboid, (BigInteger)layerCuboidList.get(j));
                }
            }
            directChildrenCache.put(currentCuboid, directChildren);
        }
        return directChildrenCache;
    }

    private static void checkAndAddDirectChild(List<BigInteger> directChildren, BigInteger currentCuboid, BigInteger checkedCuboid) {
        if (CuboidStatsUtil.isDescendant(checkedCuboid, currentCuboid)) {
            boolean ifDirectChild = true;
            for (BigInteger directChild : directChildren) {
                if (!CuboidStatsUtil.isDescendant(checkedCuboid, directChild)) continue;
                ifDirectChild = false;
                break;
            }
            if (ifDirectChild) {
                directChildren.add(checkedCuboid);
            }
        }
    }

    private static boolean isDescendant(BigInteger cuboidToCheck, BigInteger parentCuboid) {
        return cuboidToCheck.and(parentCuboid).equals(cuboidToCheck);
    }

    private static double calculateRollupRatio(Pair<Long, Long> rollupStats) {
        double rollupInputCount = (double)((Long)rollupStats.getFirst()).longValue() + (double)((Long)rollupStats.getSecond()).longValue();
        return rollupInputCount == 0.0 ? 0.0 : 1.0 * (double)((Long)rollupStats.getFirst()).longValue() / rollupInputCount;
    }
}

