/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cachesync;

import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.persistence.MissingRootPersistentEntity;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;

public class CacheReloadChecker<T extends RootPersistentEntity> {
    private ResourceStore store;
    private CachedCrudAssist<T> crud;

    boolean needReload(String resourceName) {
        RootPersistentEntity entity = (RootPersistentEntity)this.crud.getCache().getIfPresent((Object)resourceName);
        if (entity == null) {
            return true;
        }
        return this.checkDependencies(entity);
    }

    private boolean checkDependencies(RootPersistentEntity entity) {
        RawResource raw = this.store.getResource(entity.getResourcePath());
        if (raw == null) {
            return !(entity instanceof MissingRootPersistentEntity);
        }
        if (raw.getMvcc() != entity.getMvcc()) {
            return true;
        }
        if (this.store.getMetadataStore() instanceof FileSystemMetadataStore && raw.getTs().longValue() != entity.getLastModified()) {
            return true;
        }
        Preconditions.checkState((!(entity instanceof MissingRootPersistentEntity) ? 1 : 0) != 0);
        List entities = entity.getDependencies();
        if (entities == null) {
            return false;
        }
        for (RootPersistentEntity depEntity : entities) {
            boolean depNeedReload = this.checkDependencies(depEntity);
            if (!depNeedReload) continue;
            return true;
        }
        return false;
    }

    @Generated
    public static <T extends RootPersistentEntity> CacheReloadCheckerBuilder<T> builder() {
        return new CacheReloadCheckerBuilder();
    }

    @Generated
    public CacheReloadChecker(ResourceStore store, CachedCrudAssist<T> crud) {
        this.store = store;
        this.crud = crud;
    }

    @Generated
    public static class CacheReloadCheckerBuilder<T extends RootPersistentEntity> {
        @Generated
        private ResourceStore store;
        @Generated
        private CachedCrudAssist<T> crud;

        @Generated
        CacheReloadCheckerBuilder() {
        }

        @Generated
        public CacheReloadCheckerBuilder<T> store(ResourceStore store) {
            this.store = store;
            return this;
        }

        @Generated
        public CacheReloadCheckerBuilder<T> crud(CachedCrudAssist<T> crud) {
            this.crud = crud;
            return this;
        }

        @Generated
        public CacheReloadChecker<T> build() {
            return new CacheReloadChecker<T>(this.store, this.crud);
        }

        @Generated
        public String toString() {
            return "CacheReloadChecker.CacheReloadCheckerBuilder(store=" + this.store + ", crud=" + this.crud + ")";
        }
    }
}

