/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Ordering;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.KylinTableChooserRule;
import org.apache.kylin.query.routing.PartitionPruningRule;
import org.apache.kylin.query.routing.PruningRule;
import org.apache.kylin.query.routing.RemoveIncapableRealizationsRule;
import org.apache.kylin.query.routing.SegmentPruningRule;
import org.apache.kylin.query.routing.VacantIndexPruningRule;

public class QueryRouter {
    public static final String USE_VACANT_INDEXES = "use-vacant-indexes";

    private QueryRouter() {
    }

    private static Set<String> getPruningRules(KylinConfig config) {
        String queryIndexMatchRules = config.getQueryIndexMatchRules();
        String[] splitRules = queryIndexMatchRules.split(",");
        HashSet configRules = Sets.newHashSet();
        for (String splitRule : splitRules) {
            if (!StringUtils.isNotBlank((CharSequence)splitRule)) continue;
            configRules.add(StringUtils.lowerCase((String)splitRule.trim()));
        }
        return configRules;
    }

    public static boolean isVacantIndexPruningEnabled(KylinConfig config) {
        return QueryRouter.getPruningRules(config).contains(USE_VACANT_INDEXES);
    }

    public static void applyRules(Candidate candidate) {
        Strategy pruningStrategy = QueryRouter.getStrategy(candidate.getCtx().getOlapSchema().getProject());
        for (PruningRule r : pruningStrategy.getRules()) {
            r.apply(candidate);
        }
    }

    public static void sortCandidates(String project, List<Candidate> candidates) {
        Strategy strategy = QueryRouter.getStrategy(project);
        candidates.sort(strategy.getSorter());
    }

    private static Strategy getStrategy(String project) {
        return new Strategy(NProjectManager.getProjectConfig((String)project));
    }

    public static class Strategy {
        private static final PruningRule SEGMENT_PRUNING = new SegmentPruningRule();
        private static final PruningRule PARTITION_PRUNING = new PartitionPruningRule();
        private static final PruningRule REMOVE_INCAPABLE_REALIZATIONS = new RemoveIncapableRealizationsRule();
        private static final PruningRule VACANT_INDEX_PRUNING = new VacantIndexPruningRule();
        private static final PruningRule KYLIN_TABLE_PRUNING = new KylinTableChooserRule();
        List<PruningRule> rules = Lists.newArrayList();
        private final List<Comparator<Candidate>> sorters = Lists.newArrayList();

        public Comparator<Candidate> getSorter() {
            return Ordering.compound(this.sorters);
        }

        public Strategy(KylinConfig config) {
            if (config.isQueryDryRunEnabled() && QueryContext.current().getModelPriorities().length > 0) {
                this.rules.add(new PruningRule(){

                    @Override
                    public void apply(Candidate candidate) {
                        HashSet models = Sets.newHashSet((Object[])QueryContext.current().getModelPriorities());
                        boolean matched = false;
                        for (IRealization r : candidate.getRealization().getRealizations()) {
                            NDataflow df = (NDataflow)r;
                            if (!models.contains(df.getModelAlias().toUpperCase(Locale.ROOT))) continue;
                            matched = true;
                        }
                        if (!matched) {
                            CapabilityResult capability = new CapabilityResult();
                            capability.setCapable(false);
                            candidate.setCapability(capability);
                        }
                    }

                    @Override
                    public boolean isStorageMatch(Candidate candidate) {
                        return false;
                    }
                });
            }
            this.rules.add(KYLIN_TABLE_PRUNING);
            this.rules.add(SEGMENT_PRUNING);
            this.rules.add(PARTITION_PRUNING);
            this.rules.add(REMOVE_INCAPABLE_REALIZATIONS);
            if (QueryRouter.isVacantIndexPruningEnabled(config)) {
                this.rules.add(VACANT_INDEX_PRUNING);
            }
            if (config.useTableIndexAnswerSelectStarEnabled()) {
                this.sorters.add(Candidate.tableIndexUnmatchedColSizeSorter());
            }
            this.sorters.add(Candidate.modelPrioritySorter());
            this.sorters.add(Candidate.realizationCostSorter());
            this.sorters.add(Candidate.partialResultSorter());
            this.sorters.add(Candidate.realizationCapabilityCostSorter());
            this.sorters.add(Candidate.modelUuidSorter());
        }

        @Generated
        public List<PruningRule> getRules() {
            return this.rules;
        }
    }
}

