/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.rest.cache.KylinCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinEhCache
implements KylinCache {
    private static final Logger logger = LoggerFactory.getLogger(KylinEhCache.class);
    private CacheManager cacheManager;

    private KylinEhCache() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String cacheConfigLocation = kylinConfig.getEhCacheConfigPath();
        try {
            logger.info("Trying to load ehcache properties from {}.", (Object)cacheConfigLocation);
            this.cacheManager = CacheManager.create((URL)new URL(cacheConfigLocation));
        }
        catch (MalformedURLException | CacheException e) {
            logger.error("Create cache manager failed with config path: {}, will use default ehcache.xml", (Object)cacheConfigLocation, (Object)e);
            this.cacheManager = CacheManager.create((InputStream)ClassLoader.getSystemResourceAsStream("ehcache.xml"));
        }
    }

    public static KylinCache getInstance() {
        return (KylinCache)Singletons.getInstance(KylinEhCache.class);
    }

    public Ehcache getEhCache(String type, String project) {
        String projectCacheName = String.format(Locale.ROOT, "%s-%s", type, project);
        if (this.cacheManager.getEhcache(projectCacheName) == null) {
            CacheConfiguration cacheConfiguration = this.cacheManager.getEhcache(type).getCacheConfiguration().clone();
            cacheConfiguration.setName(projectCacheName);
            this.cacheManager.addCacheIfAbsent((Ehcache)new Cache(cacheConfiguration));
        }
        return this.cacheManager.getEhcache(projectCacheName);
    }

    public void put(String type, String project, Object key, Object value) {
        Ehcache ehcache = this.getEhCache(type, project);
        ehcache.put(new Element(key, value));
    }

    public void update(String type, String project, Object key, Object value) {
        this.put(type, project, key, value);
    }

    public Object get(String type, String project, Object key) {
        Ehcache ehcache = this.getEhCache(type, project);
        Element element = ehcache.get(key);
        return element == null ? null : element.getObjectValue();
    }

    public boolean remove(String type, String project, Object key) {
        Ehcache ehcache = this.getEhCache(type, project);
        return ehcache.remove(key);
    }

    public void clearAll() {
        this.cacheManager.clearAll();
    }

    public void clearByType(String type, String project) {
        String[] cacheNames;
        String projectCacheName = String.format(Locale.ROOT, "%s-%s", type, project);
        for (String cacheName : cacheNames = this.cacheManager.getCacheNames()) {
            Ehcache ehcache = this.cacheManager.getEhcache(cacheName);
            if (ehcache == null || !cacheName.contains(projectCacheName)) continue;
            ehcache.removeAll();
        }
    }
}

