/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry.ogc;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorExportToWkb;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import java.nio.ByteBuffer;

public final class OGCPoint
extends OGCGeometry {
    public static String TYPE = "Point";
    Point point;

    public OGCPoint(Point pt, SpatialReference sr) {
        this.point = pt;
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 1);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(1, this.getEsriGeometry(), null);
    }

    public double X() {
        return this.point.getX();
    }

    public double Y() {
        return this.point.getY();
    }

    public double Z() {
        return this.point.getZ();
    }

    public double M() {
        return this.point.getM();
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.point != null ? this.point.estimateMemorySize() : 0L);
    }

    @Override
    public OGCGeometry boundary() {
        return new OGCMultiPoint(new MultiPoint(this.getEsriGeometry().getDescription()), this.esriSR);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.point;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiPoint(this.point, this.esriSR);
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        return this;
    }
}

