/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.response.ParameterResponse;
import org.apache.kylin.rest.response.SimplifiedMeasure;

public class SynchronizedCommentsResponse {
    @JsonProperty(value="model_request")
    private ModelRequest modelRequest;
    @JsonProperty(value="conflict_info")
    private ConflictInfo conflictInfo;
    public static final Pattern SPECIAL_CHAR_PTN = Pattern.compile("((?![\\u4E00-\\u9FA5a-zA-Z0-9 _\\-()%?\uff08\uff09]+).)*");

    public void syncComment(ModelRequest modelRequest) {
        this.modelRequest = modelRequest;
        Map<String, ColumnDesc> columnDescMap = this.getColumnDescMap();
        this.syncDimensionNames(columnDescMap, modelRequest.getSimplifiedDimensions());
        this.syncMeasureComments(columnDescMap, modelRequest.getSimplifiedMeasures());
    }

    private void syncDimensionNames(Map<String, ColumnDesc> columnDescMap, List<NDataModel.NamedColumn> simplifiedDimensions) {
        ArrayList colsWithSameComment = Lists.newArrayList();
        ArrayList dimsOriginFromSameCol = Lists.newArrayList();
        simplifiedDimensions.forEach(namedColumn -> {
            String aliasDotColumn = StringUtils.upperCase((String)namedColumn.getAliasDotColumn());
            ColumnDesc columnDesc = (ColumnDesc)columnDescMap.get(aliasDotColumn);
            String name = StringUtils.upperCase((String)namedColumn.getColTableName());
            if (columnDesc == null) {
                return;
            }
            String canonicalName = StringUtils.upperCase((String)columnDesc.getCanonicalName());
            List columnDescList = simplifiedDimensions.stream().map(simpleDimension -> (ColumnDesc)columnDescMap.get(StringUtils.upperCase((String)simpleDimension.getAliasDotColumn()))).filter(Objects::nonNull).filter(column -> StringUtils.upperCase((String)column.getCanonicalName()).equals(canonicalName)).collect(Collectors.toList());
            long dimsOriginFromSameColCount = columnDescList.size();
            long colsWithSameCommentCount = simplifiedDimensions.stream().map(simpleDimension -> (ColumnDesc)columnDescMap.get(StringUtils.upperCase((String)simpleDimension.getAliasDotColumn()))).filter(Objects::nonNull).filter(column -> StringUtils.isNotBlank((CharSequence)column.getComment()) && StringUtils.isNotBlank((CharSequence)columnDesc.getComment()) && StringUtils.upperCase((String)column.getComment()).equals(StringUtils.upperCase((String)columnDesc.getComment()))).count();
            if (dimsOriginFromSameColCount > 1L) {
                dimsOriginFromSameCol.add(name);
            }
            if (colsWithSameCommentCount > 1L) {
                colsWithSameComment.add(name);
            }
            if (dimsOriginFromSameColCount == 1L && colsWithSameCommentCount == 1L && StringUtils.isNotBlank((CharSequence)columnDesc.getComment())) {
                name = columnDesc.getComment();
            }
            namedColumn.setName(name);
        });
        this.modelRequest.setSimplifiedDimensions(simplifiedDimensions);
        this.conflictInfo = new ConflictInfo(colsWithSameComment, dimsOriginFromSameCol);
    }

    private void syncMeasureComments(Map<String, ColumnDesc> columnDescMap, List<SimplifiedMeasure> simplifiedMeasures) {
        simplifiedMeasures.forEach(simplifiedMeasure -> {
            List parameterResponses = simplifiedMeasure.getParameterValue().stream().filter(parameterResponse -> !"constant".equals(parameterResponse.getType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(parameterResponses)) {
                return;
            }
            String aliasDotColumn = ((ParameterResponse)parameterResponses.get(0)).getValue();
            ColumnDesc columnDesc = (ColumnDesc)columnDescMap.get(aliasDotColumn);
            if (columnDesc != null && StringUtils.isNotBlank((CharSequence)columnDesc.getComment())) {
                simplifiedMeasure.setComment(columnDesc.getComment());
            }
        });
        this.modelRequest.setSimplifiedMeasures(simplifiedMeasures);
    }

    public Map<String, ColumnDesc> getColumnDescMap() {
        HashMap columnDescMap = Maps.newHashMap();
        String project = this.modelRequest.getProject();
        String factTableName = this.modelRequest.getRootFactTableName();
        Set computedColumnNames = this.modelRequest.getComputedColumnNames().stream().map(StringUtils::upperCase).collect(Collectors.toSet());
        List joinTables = this.modelRequest.getJoinTables();
        List<NDataModel.NamedColumn> simplifiedDimensions = this.modelRequest.getSimplifiedDimensions();
        simplifiedDimensions.forEach(namedColumn -> this.putColumnDesc(project, computedColumnNames, factTableName, joinTables, columnDescMap, namedColumn.getAliasDotColumn()));
        List<SimplifiedMeasure> simplifiedMeasures = this.modelRequest.getSimplifiedMeasures();
        simplifiedMeasures.forEach(simplifiedMeasure -> {
            List<ParameterResponse> parameterResponses = simplifiedMeasure.getParameterValue().stream().filter(parameterResponse -> !"constant".equals(parameterResponse.getType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(parameterResponses)) {
                return;
            }
            parameterResponses.forEach(parameterResponse -> this.putColumnDesc(project, computedColumnNames, factTableName, joinTables, columnDescMap, parameterResponse.getValue()));
        });
        return columnDescMap;
    }

    private void putColumnDesc(String project, Set<String> computedColumnNames, String factTableName, List<JoinTableDesc> joinTables, Map<String, ColumnDesc> columnDescMap, String aliasDotColumn) {
        if (aliasDotColumn == null) {
            return;
        }
        ColumnDesc columnDesc = this.getColumnDescByAliasDotColumn(project, StringUtils.upperCase((String)aliasDotColumn), computedColumnNames, StringUtils.upperCase((String)factTableName), joinTables);
        if (columnDesc != null) {
            columnDescMap.put(aliasDotColumn, columnDesc);
        }
    }

    private ColumnDesc getColumnDescByAliasDotColumn(String project, String aliasDotColumn, Set<String> computedColumnNames, String factTableName, List<JoinTableDesc> joinTables) {
        TableDesc tableDesc;
        String[] aliasDotColumnSplit = aliasDotColumn.split("\\.");
        if (aliasDotColumnSplit.length != 2) {
            return null;
        }
        String tableName = aliasDotColumnSplit[0];
        String columnName = aliasDotColumnSplit[1];
        if (computedColumnNames.contains(aliasDotColumn) || computedColumnNames.contains(columnName)) {
            return null;
        }
        String factTableAlias = factTableName;
        if (factTableName.contains(".") && factTableName.split("\\.").length == 2) {
            factTableAlias = factTableName.split("\\.")[1];
        }
        NTableMetadataManager mgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        if (tableName.equals(factTableAlias)) {
            tableDesc = mgr.getTableDesc(factTableName);
        } else {
            Optional<JoinTableDesc> joinTable = joinTables.stream().filter(joinTableDesc -> StringUtils.upperCase((String)joinTableDesc.getAlias()).equals(tableName)).findFirst();
            if (joinTable.isPresent()) {
                tableDesc = mgr.getTableDesc(joinTable.get().getTable());
            } else {
                return null;
            }
        }
        Optional<ColumnDesc> column = Arrays.stream(tableDesc.getColumns()).filter(columnDesc -> StringUtils.upperCase((String)columnDesc.getName()).equals(columnName)).findFirst();
        if (column.isPresent()) {
            ColumnDesc columnDesc2 = column.get();
            String comment = columnDesc2.getComment();
            if (comment != null) {
                columnDesc2.setComment(this.replaceInvalidCharacters(comment.trim()));
            }
            return columnDesc2;
        }
        return null;
    }

    private String replaceInvalidCharacters(String name) {
        Matcher matcher = SPECIAL_CHAR_PTN.matcher(name);
        return matcher.replaceAll("");
    }

    @Generated
    public SynchronizedCommentsResponse() {
    }

    @Generated
    public ModelRequest getModelRequest() {
        return this.modelRequest;
    }

    @Generated
    public ConflictInfo getConflictInfo() {
        return this.conflictInfo;
    }

    @Generated
    public void setModelRequest(ModelRequest modelRequest) {
        this.modelRequest = modelRequest;
    }

    @Generated
    public void setConflictInfo(ConflictInfo conflictInfo) {
        this.conflictInfo = conflictInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronizedCommentsResponse)) {
            return false;
        }
        SynchronizedCommentsResponse other = (SynchronizedCommentsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ModelRequest this$modelRequest = this.getModelRequest();
        ModelRequest other$modelRequest = other.getModelRequest();
        if (this$modelRequest == null ? other$modelRequest != null : !((Object)((Object)this$modelRequest)).equals((Object)other$modelRequest)) {
            return false;
        }
        ConflictInfo this$conflictInfo = this.getConflictInfo();
        ConflictInfo other$conflictInfo = other.getConflictInfo();
        return !(this$conflictInfo == null ? other$conflictInfo != null : !((Object)this$conflictInfo).equals(other$conflictInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SynchronizedCommentsResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModelRequest $modelRequest = this.getModelRequest();
        result = result * 59 + ($modelRequest == null ? 43 : ((Object)((Object)$modelRequest)).hashCode());
        ConflictInfo $conflictInfo = this.getConflictInfo();
        result = result * 59 + ($conflictInfo == null ? 43 : ((Object)$conflictInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SynchronizedCommentsResponse(modelRequest=" + (Object)((Object)this.getModelRequest()) + ", conflictInfo=" + this.getConflictInfo() + ")";
    }

    public static class ConflictInfo
    implements Serializable {
        @JsonProperty(value="cols_with_same_comment")
        private List<String> colsWithSameComment;
        @JsonProperty(value="dims_origin_from_same_col")
        private List<String> dimsOriginFromSameCol;

        @Generated
        public List<String> getColsWithSameComment() {
            return this.colsWithSameComment;
        }

        @Generated
        public List<String> getDimsOriginFromSameCol() {
            return this.dimsOriginFromSameCol;
        }

        @Generated
        public void setColsWithSameComment(List<String> colsWithSameComment) {
            this.colsWithSameComment = colsWithSameComment;
        }

        @Generated
        public void setDimsOriginFromSameCol(List<String> dimsOriginFromSameCol) {
            this.dimsOriginFromSameCol = dimsOriginFromSameCol;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConflictInfo)) {
                return false;
            }
            ConflictInfo other = (ConflictInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$colsWithSameComment = this.getColsWithSameComment();
            List<String> other$colsWithSameComment = other.getColsWithSameComment();
            if (this$colsWithSameComment == null ? other$colsWithSameComment != null : !((Object)this$colsWithSameComment).equals(other$colsWithSameComment)) {
                return false;
            }
            List<String> this$dimsOriginFromSameCol = this.getDimsOriginFromSameCol();
            List<String> other$dimsOriginFromSameCol = other.getDimsOriginFromSameCol();
            return !(this$dimsOriginFromSameCol == null ? other$dimsOriginFromSameCol != null : !((Object)this$dimsOriginFromSameCol).equals(other$dimsOriginFromSameCol));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConflictInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $colsWithSameComment = this.getColsWithSameComment();
            result = result * 59 + ($colsWithSameComment == null ? 43 : ((Object)$colsWithSameComment).hashCode());
            List<String> $dimsOriginFromSameCol = this.getDimsOriginFromSameCol();
            result = result * 59 + ($dimsOriginFromSameCol == null ? 43 : ((Object)$dimsOriginFromSameCol).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SynchronizedCommentsResponse.ConflictInfo(colsWithSameComment=" + this.getColsWithSameComment() + ", dimsOriginFromSameCol=" + this.getDimsOriginFromSameCol() + ")";
        }

        @Generated
        public ConflictInfo(List<String> colsWithSameComment, List<String> dimsOriginFromSameCol) {
            this.colsWithSameComment = colsWithSameComment;
            this.dimsOriginFromSameCol = dimsOriginFromSameCol;
        }
    }
}

