/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell;

import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.shell.CommandReturn;
import alluxio.util.ShellUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ShellCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ShellCommand.class);
    private final String[] mCommand;

    public ShellCommand(String[] execString) {
        this.mCommand = (String[])execString.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String run() throws IOException {
        String string;
        Process process = new ProcessBuilder(this.mCommand).redirectErrorStream(true).start();
        BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
        try {
            StringBuilder output = new StringBuilder();
            String line = inReader.readLine();
            while (line != null) {
                output.append(line);
                output.append("\n");
                line = inReader.readLine();
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new ShellUtils.ExitCodeException(exitCode, output.toString());
            }
            string = output.toString();
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                try {
                    InputStream stdout;
                    InputStream inputStream = stdout = process.getInputStream();
                    synchronized (inputStream) {
                        inReader.close();
                    }
                }
                catch (IOException e2) {
                    LOG.warn(String.format("Error while closing the input stream of process %s: %s", process, e2.getMessage()));
                }
                process.destroy();
                throw throwable;
            }
        }
        try {
            InputStream stdout;
            InputStream inputStream = stdout = process.getInputStream();
            synchronized (inputStream) {
                inReader.close();
            }
        }
        catch (IOException e) {
            LOG.warn(String.format("Error while closing the input stream of process %s: %s", process, e.getMessage()));
        }
        process.destroy();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandReturn runWithOutput() throws IOException {
        Process process = null;
        BufferedReader inReader = null;
        try {
            process = new ProcessBuilder(this.mCommand).redirectErrorStream(true).start();
            inReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder stdout = new StringBuilder();
            String outLine = inReader.readLine();
            while (outLine != null) {
                stdout.append(outLine);
                stdout.append("\n");
                outLine = inReader.readLine();
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LOG.warn(String.format("Non-zero exit code (%d) from command %s", exitCode, Arrays.toString(this.mCommand)));
            }
            CommandReturn cr = new CommandReturn(exitCode, this.mCommand, stdout.toString());
            if (process != null) {
                process.destroy();
            }
            CommandReturn commandReturn = cr;
            return commandReturn;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (Exception e) {
            CommandReturn commandReturn = new CommandReturn(1, String.format("Command %s failed, exception is %s", Arrays.toString(this.mCommand), e.getMessage()));
            return commandReturn;
        }
        finally {
            if (inReader != null) {
                inReader.close();
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    public String toString() {
        return Arrays.toString(this.mCommand);
    }

    public String[] getCommand() {
        return Arrays.copyOfRange(this.mCommand, 0, this.mCommand.length);
    }
}

