/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query;

import java.util.List;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.rec.query.SQLResult;

public class QueryRecord {
    private final SQLResult sqlResult = new SQLResult();
    private final List<OlapContext> olapContexts = Lists.newArrayList();

    public void noteNonQueryException(String project, String sql, long elapsed) {
        this.sqlResult.writeNonQueryException(project, sql, elapsed);
    }

    public void noteException(String message, Throwable e) {
        this.sqlResult.writeExceptionInfo(message, e);
    }

    public void noteNormal(String project, String sql, long elapsed, String queryId) {
        this.sqlResult.writeNormalInfo(project, sql, elapsed, queryId);
    }

    public void noteOlapContexts() {
        ContextUtil.getThreadLocalContexts().forEach(ctx -> {
            ctx.setSql(this.sqlResult.getSql());
            ctx.simplify();
        });
        this.olapContexts.addAll(ContextUtil.getThreadLocalContexts());
    }

    @Generated
    public SQLResult getSqlResult() {
        return this.sqlResult;
    }

    @Generated
    public List<OlapContext> getOlapContexts() {
        return this.olapContexts;
    }
}

