/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.util.concurrent.ExecutionError;
import org.apache.kylin.guava30.shaded.common.util.concurrent.SimpleTimeLimiter;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.ContextOutput;
import org.apache.kylin.rec.SmartContext;
import org.apache.kylin.rec.SmartMaster;
import org.apache.kylin.rec.common.SmartConfig;
import org.apache.kylin.rec.runner.JobRunnerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposerJob
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProposerJob.class);
    private static final String CONTEXT_CLASS = "contextClass";
    private static final String CONTEXT_PARAMS = "contextParams";
    private static final String CONTEXT_OUTPUT = "contextOutput";
    private static final String PATH_DELIMITER = "/";
    static final Option OPTION_META_DIR = OptionBuilder.getInstance().withArgName("meta").hasArg().isRequired(true).withDescription("metadata input directory").create("meta");
    static final Option OPTION_CONTEXT_PARAMS_FILE = OptionBuilder.getInstance().withArgName("contextParams").hasArg().isRequired(true).withDescription("context params file").create("contextParams");
    static final Option OPTION_META_OUTPUT_DIR = OptionBuilder.getInstance().withArgName("metaOutput").hasArg().isRequired(true).withDescription("metadata output directory").create("metaOutput");
    static final Option OPTION_CONTEXT_CLASS = OptionBuilder.getInstance().withArgName("contextClass").hasArg().isRequired(true).withDescription("context implement").create("contextClass");
    static final Option OPTION_CONTEXT_OUTPUT_FILE = OptionBuilder.getInstance().withArgName("contextOutput").hasArg().isRequired(true).withDescription("context output file").create("contextOutput");
    protected final Options options = new Options();

    @VisibleForTesting
    public static AbstractContext proposeForAutoMode(KylinConfig config, String project, String[] sqls) {
        SmartContext context = new SmartContext(config, project, sqls);
        return ProposerJob.propose(context);
    }

    public static AbstractContext propose(AbstractContext context) {
        return ProposerJob.propose(context, JobRunnerFactory::createRunner);
    }

    public static AbstractContext propose(AbstractContext context, RunnerFactoryBuilder factoryBuilder) {
        SmartConfig smartConfig = context.getSmartConfig();
        KylinConfig config = smartConfig.getKylinConfig();
        String project = context.getProject();
        ProposerJobEnv jobEnv = new ProposerJobEnv(config, project, context);
        String jobId = jobEnv.getJobId();
        JobRunnerFactory.AbstractJobRunner runner = null;
        try {
            jobEnv.buildJobEnv();
            runner = factoryBuilder.build(config, smartConfig.getProposeRunnerImpl(), project, jobEnv.getResource());
            runner.init(jobId);
            runner.start(new ProposerJob(), jobEnv.getParams());
            ProposerJob.mergeResultIntoContext(jobEnv);
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EXEC_JOB_FAILED, "Failed to exec job " + jobId, (Throwable)e);
        }
        finally {
            ProposerJob.uploadLogs(jobEnv);
            if (runner != null) {
                runner.cleanupEnv();
            }
        }
        return context;
    }

    public static void mergeResultIntoContext(ProposerJobEnv env) throws IOException {
        ContextOutput output = (ContextOutput)JsonUtil.readValue((File)new File(env.getContextOutputFile()), ContextOutput.class);
        ProposerJob.initModelsForOutput(env.getProject(), env.getKylinConfig(), output);
        ContextOutput.merge(env.getContext(), output);
    }

    public static void uploadLogs(ProposerJobEnv env) {
        String jobContentZip = env.getJobTmpDir() + ".zip";
        try {
            SimpleTimeLimiter.create((ExecutorService)ForkJoinPool.commonPool()).callWithTimeout(() -> ProposerJob.uploadJobLog(env, jobContentZip), Duration.ofSeconds(10L));
        }
        catch (InterruptedException e) {
            log.warn("Upload job Interrupted! The job id is: {}", (Object)env.getJobId(), (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception | ExecutionError e) {
            log.warn("Upload Job Evidence failed {}", (Object)env.getJobId(), (Object)e);
        }
        finally {
            FileUtils.deleteQuietly((File)new File(jobContentZip));
        }
    }

    private static void initModelsForOutput(String project, KylinConfig config, ContextOutput output) {
        output.getModelContextOutputs().forEach(modelOutput -> {
            NDataModel targetModel;
            NDataModel originModel = modelOutput.getOriginModel();
            if (originModel != null) {
                originModel.init(config, project, (List)Lists.newArrayList());
            }
            if ((targetModel = modelOutput.getTargetModel()) != null) {
                Map<String, ComputedColumnDesc> usedCCMap = modelOutput.getUsedCC().values().stream().collect(Collectors.toMap(RootPersistentEntity::getUuid, cc -> cc));
                targetModel.setComputedColumnDescs(targetModel.getComputedColumnUuids().stream().map(usedCCMap::get).collect(Collectors.toList()));
                targetModel.init(config, project, (List)Lists.newArrayList());
            }
            modelOutput.getMeasureRecItemMap().forEach((key, m) -> {
                NDataModel.Measure measure = m.getMeasure();
                measure.getFunction().init(targetModel);
            });
        });
    }

    private static boolean uploadJobLog(ProposerJobEnv env, String jobContentZip) throws IOException {
        ZipFileUtils.compressZipFile((String)env.getJobTmpDir(), (String)jobContentZip);
        String jobDir = KylinConfig.getInstanceFromEnv().getJobTmpDir(env.getProject(), true);
        FileSystem fs = HadoopUtil.getFileSystem((String)jobDir);
        try (FileInputStream in = new FileInputStream(jobContentZip);
             FSDataOutputStream out = fs.create(new Path(jobDir + env.getJobId() + ".zip"), true);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return true;
    }

    public ProposerJob() {
        this.options.addOption(OPTION_META_DIR);
        this.options.addOption(OPTION_CONTEXT_PARAMS_FILE);
        this.options.addOption(OPTION_META_OUTPUT_DIR);
        this.options.addOption(OPTION_CONTEXT_CLASS);
        this.options.addOption(OPTION_CONTEXT_OUTPUT_FILE);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String metaDir = optionsHelper.getOptionValue(OPTION_META_DIR);
        String contextParamsFile = optionsHelper.getOptionValue(OPTION_CONTEXT_PARAMS_FILE);
        String contextOutputFile = optionsHelper.getOptionValue(OPTION_CONTEXT_OUTPUT_FILE);
        String contextClass = optionsHelper.getOptionValue(OPTION_CONTEXT_CLASS);
        ContextParams contextParams = (ContextParams)JsonUtil.readValue((File)new File(contextParamsFile), ContextParams.class);
        List<String> sqls = contextParams.getSqls();
        String project = contextParams.getProject();
        String modelName = contextParams.getModelName();
        String propertiesFilePath = metaDir + PATH_DELIMITER + "kylin.properties";
        try (KylinConfig.SetAndUnsetThreadLocalConfig config = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)KylinConfig.createInstanceFromUri((String)propertiesFilePath));){
            AbstractContext context;
            Constructor<?> contextConstructor;
            if (StringUtils.isNotEmpty((CharSequence)modelName)) {
                contextConstructor = Class.forName(contextClass).getConstructor(KylinConfig.class, String.class, String[].class, String.class);
                context = (AbstractContext)contextConstructor.newInstance(KylinConfig.getInstanceFromEnv(), project, sqls.toArray(new String[0]), modelName);
            } else {
                contextConstructor = Class.forName(contextClass).getConstructor(KylinConfig.class, String.class, String[].class);
                context = (AbstractContext)contextConstructor.newInstance(KylinConfig.getInstanceFromEnv(), project, sqls.toArray(new String[0]));
            }
            Unsafe.setProperty((String)"needCheckCC", (String)"true");
            context.getExtraMeta().setAllModels(contextParams.getAllModels());
            context.getExtraMeta().setOnlineModelIds(contextParams.getOnlineModelIds());
            context.getExtraMeta().setModelOptRule(contextParams.getModelOptRule());
            context.setCanCreateNewModel(contextParams.isCanCreateNewModel());
            context.setRestoredProposeContext(true);
            new SmartMaster(context).runWithContext(null);
            ContextOutput output = ContextOutput.from(context);
            JsonUtil.writeValue((File)new File(contextOutputFile), (Object)output);
            ResourceStore.clearCache((KylinConfig)config.get());
        }
    }

    public static void setKylinConf(String[] args) {
        String metaDir = "";
        for (String arg : args) {
            if (!arg.startsWith("--meta=")) continue;
            metaDir = arg.substring("--meta=".length());
            break;
        }
        Unsafe.setProperty((String)"KYLIN_CONF", (String)metaDir);
    }

    public static void main(String[] args) {
        ProposerJob tool = new ProposerJob();
        try {
            ProposerJob.setKylinConf(args);
            tool.execute(args);
        }
        catch (Exception e) {
            log.warn("Propose {} failed", (Object)args, (Object)e);
            Unsafe.systemExit((int)1);
        }
        log.info("Propose finished");
        Unsafe.systemExit((int)0);
    }

    public static interface RunnerFactoryBuilder {
        public JobRunnerFactory.AbstractJobRunner build(KylinConfig var1, String var2, String var3, List<String> var4);
    }

    static class ContextParams
    implements Serializable {
        private String project;
        private boolean canCreateNewModel;
        private String modelOptRule;
        private List<String> sqls = Lists.newArrayList();
        private Set<String> allModels = Sets.newHashSet();
        private Set<String> onlineModelIds = Sets.newHashSet();
        private String modelName;

        public ContextParams(AbstractContext context, Set<String> allModelNames, Set<String> onlineModelIds) {
            this.project = context.getProject();
            this.modelOptRule = context.getSmartConfig().getModelOptRule();
            this.canCreateNewModel = context.canCreateNewModel;
            this.sqls = Arrays.asList(context.getSqlArray());
            this.allModels.addAll(allModelNames);
            this.onlineModelIds.addAll(onlineModelIds);
            this.modelName = context.getModelName();
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public boolean isCanCreateNewModel() {
            return this.canCreateNewModel;
        }

        @Generated
        public String getModelOptRule() {
            return this.modelOptRule;
        }

        @Generated
        public List<String> getSqls() {
            return this.sqls;
        }

        @Generated
        public Set<String> getAllModels() {
            return this.allModels;
        }

        @Generated
        public Set<String> getOnlineModelIds() {
            return this.onlineModelIds;
        }

        @Generated
        public String getModelName() {
            return this.modelName;
        }

        @Generated
        public void setProject(String project) {
            this.project = project;
        }

        @Generated
        public void setCanCreateNewModel(boolean canCreateNewModel) {
            this.canCreateNewModel = canCreateNewModel;
        }

        @Generated
        public void setModelOptRule(String modelOptRule) {
            this.modelOptRule = modelOptRule;
        }

        @Generated
        public void setSqls(List<String> sqls) {
            this.sqls = sqls;
        }

        @Generated
        public void setAllModels(Set<String> allModels) {
            this.allModels = allModels;
        }

        @Generated
        public void setOnlineModelIds(Set<String> onlineModelIds) {
            this.onlineModelIds = onlineModelIds;
        }

        @Generated
        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContextParams)) {
                return false;
            }
            ContextParams other = (ContextParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$project = this.getProject();
            String other$project = other.getProject();
            if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
                return false;
            }
            if (this.isCanCreateNewModel() != other.isCanCreateNewModel()) {
                return false;
            }
            String this$modelOptRule = this.getModelOptRule();
            String other$modelOptRule = other.getModelOptRule();
            if (this$modelOptRule == null ? other$modelOptRule != null : !this$modelOptRule.equals(other$modelOptRule)) {
                return false;
            }
            List<String> this$sqls = this.getSqls();
            List<String> other$sqls = other.getSqls();
            if (this$sqls == null ? other$sqls != null : !((Object)this$sqls).equals(other$sqls)) {
                return false;
            }
            Set<String> this$allModels = this.getAllModels();
            Set<String> other$allModels = other.getAllModels();
            if (this$allModels == null ? other$allModels != null : !((Object)this$allModels).equals(other$allModels)) {
                return false;
            }
            Set<String> this$onlineModelIds = this.getOnlineModelIds();
            Set<String> other$onlineModelIds = other.getOnlineModelIds();
            if (this$onlineModelIds == null ? other$onlineModelIds != null : !((Object)this$onlineModelIds).equals(other$onlineModelIds)) {
                return false;
            }
            String this$modelName = this.getModelName();
            String other$modelName = other.getModelName();
            return !(this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ContextParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            result = result * 59 + (this.isCanCreateNewModel() ? 79 : 97);
            String $modelOptRule = this.getModelOptRule();
            result = result * 59 + ($modelOptRule == null ? 43 : $modelOptRule.hashCode());
            List<String> $sqls = this.getSqls();
            result = result * 59 + ($sqls == null ? 43 : ((Object)$sqls).hashCode());
            Set<String> $allModels = this.getAllModels();
            result = result * 59 + ($allModels == null ? 43 : ((Object)$allModels).hashCode());
            Set<String> $onlineModelIds = this.getOnlineModelIds();
            result = result * 59 + ($onlineModelIds == null ? 43 : ((Object)$onlineModelIds).hashCode());
            String $modelName = this.getModelName();
            result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProposerJob.ContextParams(project=" + this.getProject() + ", canCreateNewModel=" + this.isCanCreateNewModel() + ", modelOptRule=" + this.getModelOptRule() + ", sqls=" + this.getSqls() + ", allModels=" + this.getAllModels() + ", onlineModelIds=" + this.getOnlineModelIds() + ", modelName=" + this.getModelName() + ")";
        }

        @Generated
        public ContextParams() {
        }
    }

    private static class ProposerJobEnv {
        String project;
        KylinConfig config;
        AbstractContext context;
        String jobId;
        Set<String> onlineModelIdSet = Sets.newHashSet();
        Set<String> allModelNames = Sets.newHashSet();
        List<String> resources = Lists.newArrayList();
        Map<String, String> params = Maps.newHashMap();
        String contextOutputFile;

        public ProposerJobEnv(KylinConfig config, String project, AbstractContext context) {
            this.project = project;
            this.config = config;
            this.context = context;
            this.jobId = this.generateJobId(project);
        }

        public void buildJobEnv() throws IOException {
            FileUtils.forceMkdir((File)new File(this.getJobTmpDir()));
            this.extractDumpResource();
            this.generateParams();
        }

        public String getJobTmpDir() {
            return KylinConfigBase.getKylinHome() + "/tmp/" + this.jobId;
        }

        public void extractDumpResource() {
            this.extractProjectResources();
            this.extractModelAndIndexPlanResources();
            this.extractTableResources();
            this.extractKafkaResources();
        }

        private void extractProjectResources() {
            String projectPath = MetadataType.mergeKeyWithType((String)this.project, (MetadataType)MetadataType.PROJECT);
            this.resources.add(projectPath);
        }

        private void extractModelAndIndexPlanResources() {
            List<NDataModel> baseModels = this.context.getRelatedModels();
            Set allModelIdSet = baseModels.stream().map(RootPersistentEntity::getUuid).collect(Collectors.toSet());
            NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project).listAllDataflows(true).forEach(df -> {
                NDataModel model = df.getModel();
                this.allModelNames.add(model.getAlias().toLowerCase(Locale.ROOT));
                if (model.isBroken() || !allModelIdSet.contains(model.getUuid())) {
                    return;
                }
                if (model.isFusionModel()) {
                    return;
                }
                this.resources.add(model.getResourcePath());
                this.resources.addAll(model.getComputedColumnDescs().stream().map(RootPersistentEntity::getResourcePath).collect(Collectors.toList()));
                this.resources.add(MetadataType.mergeKeyWithType((String)model.getId(), (MetadataType)MetadataType.INDEX_PLAN));
                this.resources.addAll(df.getSegments().stream().map(RootPersistentEntity::getResourcePath).collect(Collectors.toList()));
                if (df.getStatus() == RealizationStatusEnum.ONLINE) {
                    this.onlineModelIdSet.add(model.getUuid());
                }
            });
        }

        private void extractTableResources() {
            Set<String> baseTables = this.context.getRelatedTables();
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)this.config, (String)this.project);
            baseTables.forEach(tableIdentity -> {
                TableDesc tableDesc = tableManager.getTableDesc(tableIdentity);
                if (tableDesc != null) {
                    String resourcePath;
                    TableExtDesc tableExtDesc;
                    String tablePath = tableDesc.getResourcePath();
                    if (StringUtils.isNotEmpty((CharSequence)tablePath)) {
                        this.resources.add(tablePath);
                    }
                    if ((tableExtDesc = tableManager.getTableExtIfExists(tableDesc)) != null && StringUtils.isNotEmpty((CharSequence)(resourcePath = tableExtDesc.getResourcePath()))) {
                        this.resources.add(resourcePath);
                    }
                }
            });
        }

        private void extractKafkaResources() {
            Set<String> baseTables = this.context.getRelatedTables();
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)this.config, (String)this.project);
            HashSet kafkaResources = Sets.newHashSet();
            baseTables.forEach(tableIdentity -> {
                String tableKafkaPath;
                TableDesc tableDesc = tableManager.getTableDesc(tableIdentity);
                if (tableDesc == null) {
                    return;
                }
                if (tableDesc.getSourceType() == 1 && StringUtils.isNotEmpty((CharSequence)(tableKafkaPath = tableDesc.getKafkaConfig().getResourcePath()))) {
                    this.resources.add(tableKafkaPath);
                }
            });
            this.resources.addAll(kafkaResources);
        }

        public void generateParams() throws IOException {
            String jobTmpDir = this.getJobTmpDir();
            this.params.put(ProposerJob.CONTEXT_CLASS, this.context.getClass().getName());
            String contextParamsFile = jobTmpDir + "/context_params.json";
            this.writeContextParams(contextParamsFile);
            this.params.put(ProposerJob.CONTEXT_PARAMS, contextParamsFile);
            this.contextOutputFile = jobTmpDir + "/context_output.json";
            this.params.put(ProposerJob.CONTEXT_OUTPUT, this.contextOutputFile);
        }

        private void writeContextParams(String contextParamsFile) throws IOException {
            ContextParams contextParams = new ContextParams(this.context, this.allModelNames, this.onlineModelIdSet);
            JsonUtil.writeValue((File)new File(contextParamsFile), (Object)contextParams);
        }

        public List<String> getResource() {
            return this.resources;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public String getJobId() {
            return this.jobId;
        }

        private String generateJobId(String project) {
            return project + "-" + LocalDateTime.now(Clock.systemDefaultZone()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSS", Locale.getDefault(Locale.Category.FORMAT))) + "-" + RandomUtil.randomUUIDStr();
        }

        public String getProject() {
            return this.project;
        }

        public String getContextOutputFile() {
            return this.contextOutputFile;
        }

        public KylinConfig getKylinConfig() {
            return this.config;
        }

        public AbstractContext getContext() {
            return this.context;
        }
    }
}

