/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import lombok.Generated;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.index.IndexMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexPlanOptProposer
extends AbstractProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexPlanOptProposer.class);

    public IndexPlanOptProposer(AbstractContext proposeContext) {
        super(proposeContext);
    }

    @Override
    public void execute() {
        if (this.proposeContext.getModelContexts() == null) {
            return;
        }
        for (AbstractContext.ModelContext modelCtx : this.proposeContext.getModelContexts()) {
            IndexMaster indexMaster = new IndexMaster(modelCtx);
            if (modelCtx.isTargetModelMissing() || modelCtx.isSnapshotSelected()) continue;
            try {
                IndexPlan indexPlan = modelCtx.getTargetIndexPlan();
                if (indexPlan == null) {
                    indexPlan = indexMaster.proposeInitialIndexPlan();
                }
                indexPlan = indexMaster.proposeCuboids(indexPlan);
                modelCtx.setTargetIndexPlan(indexPlan);
            }
            catch (Exception e) {
                log.error("[UNLIKELY_THINGS_HAPPENED] Something wrong occurs in initialize target indexPlan.", (Throwable)e);
                modelCtx.setTargetIndexPlan(null);
                this.proposeContext.recordException(modelCtx, e);
            }
        }
    }

    @Override
    public String getIdentifierName() {
        return "IndexPlanOptProposer";
    }
}

