/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop3CompaUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Hadoop3CompaUtil.class);

    private Hadoop3CompaUtil() {
    }

    private static final class MaybeClose
    implements Closeable {
        private Closeable toClose;

        private MaybeClose(Object o) {
            this(o, true);
        }

        private MaybeClose(Object o, boolean close) {
            this.toClose = close && o instanceof Closeable ? (Closeable)o : null;
        }

        @Override
        public void close() throws IOException {
            if (this.toClose != null) {
                try {
                    this.toClose.close();
                }
                finally {
                    this.toClose = null;
                }
            }
        }
    }

    private static final class WrappedJavaIterator<T>
    implements RemoteIterator<T>,
    Closeable {
        private final Iterator<? extends T> source;
        private final Closeable sourceToClose;

        private WrappedJavaIterator(Iterator<? extends T> source) {
            this.source = Objects.requireNonNull(source);
            this.sourceToClose = new MaybeClose(source);
        }

        public boolean hasNext() {
            return this.source.hasNext();
        }

        public T next() {
            return this.source.next();
        }

        public String toString() {
            return "FromIterator{" + this.source + '}';
        }

        @Override
        public void close() throws IOException {
            this.sourceToClose.close();
        }
    }

    public static class RemoteIterators {
        private RemoteIterators() {
        }

        public static <T> List<T> toList(RemoteIterator<T> source) throws IOException {
            ArrayList l = new ArrayList();
            RemoteIterators.foreach(source, l::add);
            return l;
        }

        public static <T> T[] toArray(RemoteIterator<T> source) throws IOException {
            return RemoteIterators.toList(source).toArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> long foreach(RemoteIterator<T> source, Consumer<? super T> consumer) throws IOException {
            long count = 0L;
            try {
                while (source.hasNext()) {
                    ++count;
                    consumer.accept(source.next());
                }
            }
            catch (Throwable throwable) {
                if (source instanceof Closeable) {
                    IOUtils.cleanupWithLogger((Logger)log, (Closeable[])new Closeable[]{(Closeable)source});
                }
                throw throwable;
            }
            if (source instanceof Closeable) {
                IOUtils.cleanupWithLogger((Logger)log, (Closeable[])new Closeable[]{(Closeable)source});
            }
            return count;
        }

        public static <T> RemoteIterator<T> remoteIteratorFromArray(T[] array) {
            return new WrappedJavaIterator(Arrays.stream(array).iterator());
        }

        public static <T> RemoteIterator<T> remoteIteratorFromIterator(Iterator<T> iterator) {
            return new WrappedJavaIterator(iterator);
        }
    }
}

