/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import org.apache.kylin.common.response.MetricsResponse;
import org.apache.kylin.query.exception.UnsupportedQueryException;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.service.DashboardService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/dashboard"})
public class DashboardController
extends NBasicController {
    public static final Logger logger = LoggerFactory.getLogger(DashboardController.class);
    @Autowired
    DashboardService dashboardService;
    @Autowired
    ModelService modelService;
    @Autowired
    QueryService queryService;

    @RequestMapping(value={"/metric/model"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getCubeMetrics(@RequestParam(value="projectName") String projectName, @RequestParam(value="modelName", required=false) String modelName) {
        this.dashboardService.checkAuthorization(projectName);
        return this.dashboardService.getModelMetrics(projectName, modelName);
    }

    @RequestMapping(value={"/metric/query"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getQueryMetrics(@RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="modelName", required=false) String cubeName, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        this.dashboardService.checkAuthorization(projectName);
        return this.dashboardService.getQueryMetrics(projectName, startTime, endTime);
    }

    @RequestMapping(value={"/metric/job"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getJobMetrics(@RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="modelName", required=false) String cubeName, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        this.dashboardService.checkAuthorization(projectName);
        return this.dashboardService.getJobMetrics(projectName, startTime, endTime);
    }

    @RequestMapping(value={"/chart/{category}/{metric}/{dimension}"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getChartData(@PathVariable String dimension, @PathVariable String metric, @PathVariable String category, @RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="modelName", required=false) String cubeName, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        this.dashboardService.checkAuthorization(projectName);
        try {
            return this.dashboardService.getChartData(category, projectName, startTime, endTime, dimension, metric);
        }
        catch (Exception e) {
            throw new UnsupportedQueryException("Category or Metric is not right: { " + e.getMessage() + " }");
        }
    }
}

