/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.text.Collator;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.util.Static;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSetMultimap;
import org.apache.kylin.guava30.shaded.common.collect.SetMultimap;

public class SqlCastFunction
extends SqlFunction {
    private final SetMultimap<SqlTypeFamily, SqlTypeFamily> nonMonotonicCasts = ImmutableSetMultimap.builder().put((Object)SqlTypeFamily.EXACT_NUMERIC, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.APPROXIMATE_NUMERIC, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.DATETIME_INTERVAL, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.EXACT_NUMERIC).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.NUMERIC).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.DATETIME_INTERVAL).put((Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.TIME).put((Object)SqlTypeFamily.TIMESTAMP, (Object)SqlTypeFamily.TIME).put((Object)SqlTypeFamily.TIME, (Object)SqlTypeFamily.DATETIME).put((Object)SqlTypeFamily.TIME, (Object)SqlTypeFamily.TIMESTAMP).build();

    public SqlCastFunction() {
        super("CAST", SqlKind.CAST, null, InferTypes.FIRST_KNOWN, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        SqlCallBinding callBinding;
        SqlNode operand0;
        assert (opBinding.getOperandCount() == 2);
        RelDataType ret = opBinding.getOperandType(1);
        RelDataType firstType = opBinding.getOperandType(0);
        ret = opBinding.getTypeFactory().createTypeWithNullability(ret, firstType.isNullable());
        if (opBinding instanceof SqlCallBinding && (SqlUtil.isNullLiteral(operand0 = (callBinding = (SqlCallBinding)opBinding).operand(0), false) || operand0 instanceof SqlDynamicParam)) {
            SqlValidatorImpl validator = (SqlValidatorImpl)callBinding.getValidator();
            validator.setValidatedNodeType(operand0, ret);
        }
        return ret;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 2);
        return "{0}({1} AS {2})";
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (SqlUtil.isNullLiteral(left, false) || left instanceof SqlDynamicParam) {
            return true;
        }
        RelDataType validatedNodeType = callBinding.getValidator().getValidatedNodeType(left);
        RelDataType returnType = SqlTypeUtil.deriveType(callBinding, right);
        if (!SqlTypeUtil.canCastFrom(returnType, validatedNodeType, true)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.toString(), returnType.toString()));
            }
            return false;
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(validatedNodeType, returnType)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.getFullTypeString(), returnType.getFullTypeString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep("AS");
        if (call.operand(1) instanceof SqlIntervalQualifier) {
            writer.sep("INTERVAL");
        }
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        Collator castToCollator;
        RelDataType castFromType = call.getOperandType(0);
        RelDataTypeFamily castFromFamily = castFromType.getFamily();
        Collator castFromCollator = castFromType.getCollation() == null ? null : castFromType.getCollation().getCollator();
        RelDataType castToType = call.getOperandType(1);
        RelDataTypeFamily castToFamily = castToType.getFamily();
        Collator collator = castToCollator = castToType.getCollation() == null ? null : castToType.getCollation().getCollator();
        if (!Objects.equals(castFromCollator, castToCollator)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (castFromFamily instanceof SqlTypeFamily && castToFamily instanceof SqlTypeFamily && this.nonMonotonicCasts.containsEntry((Object)castFromFamily, (Object)castToFamily)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return call.getOperandMonotonicity(0);
    }
}

