/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.calcite.DataContext;
import org.apache.calcite.DataContexts;
import org.apache.calcite.adapter.clone.CloneSchema;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.AbstractQueryable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.MaterializationActor;
import org.apache.calcite.materialize.MaterializationKey;
import org.apache.calcite.materialize.TileKey;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MaterializationService {
    private static final MaterializationService INSTANCE = new MaterializationService();
    private static final ThreadLocal<@Nullable MaterializationService> THREAD_INSTANCE = ThreadLocal.withInitial(MaterializationService::new);
    private static final Comparator<Pair<CalciteSchema.TableEntry, TileKey>> C = (o0, o1) -> {
        Table t0 = ((CalciteSchema.TableEntry)o0.left).getTable();
        Table t1 = ((CalciteSchema.TableEntry)o1.left).getTable();
        Double rowCount0 = t0.getStatistic().getRowCount();
        Double rowCount1 = t1.getStatistic().getRowCount();
        if (rowCount0 != null && rowCount1 != null) {
            int c = Double.compare(rowCount0, rowCount1);
            if (c != 0) {
                return c;
            }
        } else {
            if (rowCount0 == null) {
                return 1;
            }
            return -1;
        }
        return ((CalciteSchema.TableEntry)o0.left).name.compareTo(((CalciteSchema.TableEntry)o1.left).name);
    };
    private final MaterializationActor actor = new MaterializationActor();
    private final DefaultTableFactory tableFactory = new DefaultTableFactory();

    private MaterializationService() {
    }

    public @Nullable MaterializationKey defineMaterialization(CalciteSchema schema, @Nullable TileKey tileKey, String viewSql, @Nullable List<String> viewSchemaPath, @Nullable String suggestedTableName, boolean create, boolean existing) {
        return this.defineMaterialization(schema, tileKey, viewSql, viewSchemaPath, suggestedTableName, this.tableFactory, create, existing);
    }

    public @Nullable MaterializationKey defineMaterialization(CalciteSchema schema, @Nullable TileKey tileKey, String viewSql, @Nullable List<String> viewSchemaPath, @Nullable String suggestedTableName, TableFactory tableFactory, boolean create, boolean existing) {
        CalciteSchema.TableEntry tableEntry;
        MaterializationActor.QueryKey queryKey = new MaterializationActor.QueryKey(viewSql, schema, viewSchemaPath);
        MaterializationKey existingKey = this.actor.keyBySql.get(queryKey);
        if (existingKey != null) {
            return existingKey;
        }
        if (!create) {
            return null;
        }
        CalciteConnection connection = CalciteMetaImpl.connect(schema.root(), null);
        if (existing) {
            Objects.requireNonNull(suggestedTableName, "suggestedTableName");
            tableEntry = schema.getTable(suggestedTableName, true);
            if (tableEntry == null) {
                tableEntry = schema.getTableBasedOnNullaryFunction(suggestedTableName, true);
            }
        } else {
            tableEntry = null;
        }
        if (tableEntry == null) {
            tableEntry = schema.getTableBySql(viewSql);
        }
        RelDataType rowType = null;
        if (tableEntry == null) {
            Table table = tableFactory.createTable(schema, viewSql, viewSchemaPath);
            String tableName = Schemas.uniqueTableName(schema, Util.first(suggestedTableName, "m"));
            tableEntry = schema.add(tableName, table, (ImmutableList<String>)ImmutableList.of((Object)viewSql));
            Hook.CREATE_MATERIALIZATION.run(tableName);
            rowType = table.getRowType(connection.getTypeFactory());
        }
        if (rowType == null) {
            CalcitePrepare.ParseResult parse = Schemas.parse(connection, schema, viewSchemaPath, viewSql);
            rowType = parse.rowType;
        }
        MaterializationKey key = new MaterializationKey();
        MaterializationActor.Materialization materialization = new MaterializationActor.Materialization(key, schema.root(), tableEntry, viewSql, rowType, viewSchemaPath);
        this.actor.keyMap.put(materialization.key, materialization);
        this.actor.keyBySql.put(queryKey, materialization.key);
        if (tileKey != null) {
            this.actor.keyByTile.put(tileKey, materialization.key);
        }
        return key;
    }

    public @Nullable CalciteSchema.TableEntry checkValid(MaterializationKey key) {
        MaterializationActor.Materialization materialization = this.actor.keyMap.get(key);
        if (materialization != null) {
            return materialization.materializedTable;
        }
        return null;
    }

    public @Nullable Pair<CalciteSchema.TableEntry, TileKey> defineTile(Lattice lattice, ImmutableBitSet groupSet, List<Lattice.Measure> measureList, CalciteSchema schema, boolean create, boolean exact) {
        return this.defineTile(lattice, groupSet, measureList, schema, create, exact, "m" + groupSet, this.tableFactory);
    }

    public @Nullable Pair<CalciteSchema.TableEntry, TileKey> defineTile(Lattice lattice, ImmutableBitSet groupSet, List<Lattice.Measure> measureList, CalciteSchema schema, boolean create, boolean exact, String suggestedTableName, TableFactory tableFactory) {
        CalciteSchema.TableEntry tableEntry;
        CalciteSchema.TableEntry tableEntry2;
        TileKey tileKey = new TileKey(lattice, groupSet, (ImmutableList<Lattice.Measure>)ImmutableList.copyOf(measureList));
        MaterializationKey materializationKey = this.actor.keyByTile.get(tileKey);
        if (materializationKey != null && (tableEntry2 = this.checkValid(materializationKey)) != null) {
            return Pair.of(tableEntry2, tileKey);
        }
        TileKey tileKey0 = new TileKey(lattice, groupSet, (ImmutableList<Lattice.Measure>)ImmutableList.of());
        for (Object tileKey1 : this.actor.tilesByDimensionality.get((Object)tileKey0)) {
            CalciteSchema.TableEntry tableEntry3;
            assert (((TileKey)tileKey1).dimensions.equals(groupSet));
            if (!MaterializationService.allSatisfiable(measureList, (TileKey)tileKey1) || (materializationKey = this.actor.keyByTile.get(tileKey1)) == null || (tableEntry3 = this.checkValid(materializationKey)) == null) continue;
            return Pair.of(tableEntry3, tileKey1);
        }
        if (!exact) {
            PriorityQueue<Pair<CalciteSchema.TableEntry, TileKey>> queue = new PriorityQueue<Pair<CalciteSchema.TableEntry, TileKey>>(1, C);
            for (Map.Entry entry : this.actor.keyByTile.entrySet()) {
                TileKey tileKey2 = (TileKey)entry.getKey();
                if (tileKey2.lattice != lattice || !tileKey2.dimensions.contains(groupSet) || tileKey2.dimensions.equals(groupSet) || !MaterializationService.allSatisfiable(measureList, tileKey2) || (tableEntry = this.checkValid(materializationKey = (MaterializationKey)entry.getValue())) == null) continue;
                queue.add(Pair.of(tableEntry, tileKey2));
            }
            if (!queue.isEmpty()) {
                return queue.peek();
            }
        }
        if (!create) {
            return null;
        }
        ArrayList<TileKey> obsolete = new ArrayList<TileKey>();
        LinkedHashSet<Lattice.Measure> measureSet = new LinkedHashSet<Lattice.Measure>();
        for (TileKey tileKey1 : this.actor.tilesByDimensionality.get((Object)tileKey0)) {
            measureSet.addAll((Collection<Lattice.Measure>)tileKey1.measures);
            obsolete.add(tileKey1);
        }
        measureSet.addAll(measureList);
        TileKey tileKey2 = new TileKey(lattice, groupSet, (ImmutableList<Lattice.Measure>)ImmutableList.copyOf(measureSet));
        String sql = lattice.sql(groupSet, (List<Lattice.Measure>)tileKey2.measures);
        materializationKey = this.defineMaterialization(schema, tileKey2, sql, schema.path(null), suggestedTableName, tableFactory, true, false);
        if (materializationKey != null && (tableEntry = this.checkValid(materializationKey)) != null) {
            for (TileKey tileKey1 : obsolete) {
                this.actor.tilesByDimensionality.remove((Object)tileKey0, (Object)tileKey1);
                this.actor.keyByTile.remove(tileKey1);
            }
            this.actor.tilesByDimensionality.put((Object)tileKey0, (Object)tileKey2);
            this.actor.keyByTile.put(tileKey2, materializationKey);
            return Pair.of(tableEntry, tileKey2);
        }
        return null;
    }

    private static boolean allSatisfiable(List<Lattice.Measure> measureList, TileKey tileKey) {
        for (Lattice.Measure measure : measureList) {
            if (tileKey.measures.contains((Object)measure) || tileKey.dimensions.contains(measure.argBitSet())) continue;
            return false;
        }
        return true;
    }

    public List<Prepare.Materialization> query(CalciteSchema rootSchema) {
        ArrayList<Prepare.Materialization> list = new ArrayList<Prepare.Materialization>();
        for (MaterializationActor.Materialization materialization : this.actor.keyMap.values()) {
            if (materialization.rootSchema.schema != rootSchema.schema || materialization.materializedTable == null) continue;
            list.add(new Prepare.Materialization(materialization.materializedTable, materialization.sql, Objects.requireNonNull(materialization.viewSchemaPath, () -> "materialization.viewSchemaPath is null for " + materialization.materializedTable)));
        }
        return list;
    }

    public void clear() {
        this.actor.keyMap.clear();
    }

    public static void setThreadLocal() {
        THREAD_INSTANCE.set(new MaterializationService());
    }

    public static MaterializationService instance() {
        MaterializationService materializationService = THREAD_INSTANCE.get();
        if (materializationService != null) {
            return materializationService;
        }
        return INSTANCE;
    }

    public void removeMaterialization(MaterializationKey key) {
        this.actor.keyMap.remove(key);
    }

    public static class DefaultTableFactory
    implements TableFactory {
        @Override
        public Table createTable(CalciteSchema schema, String viewSql, @Nullable List<String> viewSchemaPath) {
            final CalciteConnection connection = CalciteMetaImpl.connect(schema.root(), null);
            ImmutableMap map = ImmutableMap.of((Object)((Object)CalciteConnectionProperty.CREATE_MATERIALIZATIONS), (Object)"false");
            final CalcitePrepare.CalciteSignature<Object> calciteSignature = Schemas.prepare(connection, schema, viewSchemaPath, viewSql, (ImmutableMap<CalciteConnectionProperty, String>)map);
            return CloneSchema.createCloneTable(connection.getTypeFactory(), RelDataTypeImpl.proto((RelDataType)Nullness.castNonNull((Object)calciteSignature.rowType)), calciteSignature.getCollationList(), Util.transform(calciteSignature.columns, column -> column.type.rep), new AbstractQueryable<Object>(){

                public Enumerator<Object> enumerator() {
                    DataContext dataContext = DataContexts.of(connection, Objects.requireNonNull(calciteSignature.rootSchema, "rootSchema").plus());
                    return calciteSignature.enumerable(dataContext).enumerator();
                }

                public Type getElementType() {
                    return Object.class;
                }

                public Expression getExpression() {
                    throw new UnsupportedOperationException();
                }

                public QueryProvider getProvider() {
                    return connection;
                }

                public Iterator<Object> iterator() {
                    DataContext dataContext = DataContexts.of(connection, Objects.requireNonNull(calciteSignature.rootSchema, "rootSchema").plus());
                    return calciteSignature.enumerable(dataContext).iterator();
                }
            });
        }
    }

    public static interface TableFactory {
        public Table createTable(CalciteSchema var1, String var2, @Nullable List<String> var3);
    }
}

