/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.Model;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import springfox.documentation.service.ApiListing;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ModelSpecificationMapper;

@Mapper(componentModel="spring")
public abstract class CompatibilityModelMapper {
    @Autowired
    @Value(value="${springfox.documentation.swagger.v2.use-model-v3:true}")
    private boolean useModelV3;

    Map<String, Model> modelsFromApiListings(Map<String, List<ApiListing>> apiListings) {
        if (this.useModelV3) {
            return Mappers.getMapper(ModelSpecificationMapper.class).modelsFromApiListings(apiListings);
        }
        TreeMap<String, springfox.documentation.schema.Model> definitions = new TreeMap<String, springfox.documentation.schema.Model>();
        apiListings.values().stream().flatMap(Collection::stream).forEachOrdered(each -> definitions.putAll(each.getModels()));
        return Mappers.getMapper(ModelMapper.class).mapModels(definitions);
    }
}

