/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser.utils;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.kylin.parser.AbstractDataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserBenchMark {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParserBenchMark.class);
    private static final long DATA_SIZE_20K = 20000L;
    private static final long DATA_SIZE_40K = 40000L;
    private static final long DATA_SIZE_60K = 60000L;

    private ParserBenchMark() {
    }

    public static <I> Long test20K(I input, AbstractDataParser<I> parser) {
        return ParserBenchMark.testParse(input, parser, 20000L);
    }

    public static <I> Long test40K(I input, AbstractDataParser<I> parser) {
        return ParserBenchMark.testParse(input, parser, 40000L);
    }

    public static <I> Long test60K(I input, AbstractDataParser<I> parser) {
        return ParserBenchMark.testParse(input, parser, 60000L);
    }

    public static <I> Long testWithSize(I input, AbstractDataParser<I> parser, long size) {
        ParserBenchMark.checkSize(size);
        return ParserBenchMark.testParse(input, parser, size);
    }

    private static <I> Long testParse(I input, AbstractDataParser<I> parser, long size) {
        StopWatch stopWatch = new StopWatch("Parse Testing");
        stopWatch.start();
        int i = 0;
        while ((long)i < size) {
            try {
                parser.process(input);
            }
            catch (Exception e) {
                log.error("Abnormal data during test", (Throwable)e);
            }
            ++i;
        }
        stopWatch.stop();
        return stopWatch.getTime(TimeUnit.MILLISECONDS);
    }

    private static void checkSize(long size) {
        if (size <= 0L) {
            throw new IllegalArgumentException("The number of test data size should be > 0");
        }
    }
}

