/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.impl;

import java.io.IOException;
import shadedelta.org.apache.parquet.bytes.BytesInput;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.Encoding;
import shadedelta.org.apache.parquet.column.ParquetProperties;
import shadedelta.org.apache.parquet.column.impl.ColumnWriterBase;
import shadedelta.org.apache.parquet.column.page.PageWriter;
import shadedelta.org.apache.parquet.column.statistics.Statistics;
import shadedelta.org.apache.parquet.column.values.ValuesWriter;
import shadedelta.org.apache.parquet.column.values.bitpacking.DevNullValuesWriter;
import shadedelta.org.apache.parquet.column.values.bloomfilter.BloomFilterWriter;
import shadedelta.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import shadedelta.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import shadedelta.org.apache.parquet.io.ParquetEncodingException;

final class ColumnWriterV2
extends ColumnWriterBase {
    private static final ValuesWriter NULL_WRITER = new DevNullValuesWriter();

    ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties props) {
        super(path, pageWriter, props);
    }

    ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, BloomFilterWriter bloomFilterWriter, ParquetProperties props) {
        super(path, pageWriter, bloomFilterWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path) {
        return path.getMaxRepetitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newRepetitionLevelEncoder(path));
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path) {
        return path.getMaxDefinitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newDefinitionLevelEncoder(path));
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values) throws IOException {
        BytesInput bytes = values.getBytes();
        Encoding encoding = values.getEncoding();
        this.pageWriter.writePageV2(rowCount, Math.toIntExact(statistics.getNumNulls()), valueCount, repetitionLevels.getBytes(), definitionLevels.getBytes(), encoding, bytes, statistics);
    }

    private static class RLEWriterForV2
    extends RunLengthBitPackingHybridValuesWriter {
        public RLEWriterForV2(RunLengthBitPackingHybridEncoder encoder) {
            super(encoder);
        }

        @Override
        public BytesInput getBytes() {
            try {
                return this.encoder.toBytes();
            }
            catch (IOException e) {
                throw new ParquetEncodingException(e);
            }
        }
    }
}

