/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.impala;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class ImpalaServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "IMPALA";
    public static final String SERVICE_TYPE = "IMPALA";
    public static final String ROLE_TYPE = "IMPALAD";
    public static final String SPECIALIZATION = "impalad_specialization";
    public static final String NO_SPEC = "NO_SPECIALIZATION";
    public static final String COORDINATOR_ONLY_SPEC = "COORDINATOR_ONLY";
    public static final String EXECUTOR_ONLY_SPEC = "EXECUTOR_ONLY";
    static final String SSL_ENABLED = "client_services_ssl_enabled";
    static final String HTTP_PORT = "hs2_http_port";

    @Override
    public String getService() {
        return "IMPALA";
    }

    @Override
    public String getServiceType() {
        return "IMPALA";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModelGeneratorHandleResponse handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        boolean result = false;
        String configurationIssue = null;
        if (super.handles(service, serviceConfig, role, roleConfig).handled()) {
            String specialization = this.getRoleConfigValue(roleConfig, SPECIALIZATION);
            if (specialization == null) {
                configurationIssue = "Missing configuration: impalad_specialization";
            } else {
                result = NO_SPEC.equals(specialization) || COORDINATOR_ONLY_SPEC.equals(specialization);
            }
        }
        ServiceModelGeneratorHandleResponse response = new ServiceModelGeneratorHandleResponse(result);
        if (configurationIssue != null) {
            response.addConfigurationIssue(configurationIssue);
        }
        return response;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : "http";
        String port = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/", scheme, hostname, port));
        model.addServiceProperty(SSL_ENABLED, this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        model.addRoleProperty(this.getRoleType(), HTTP_PORT, port);
        model.addRoleProperty(this.getRoleType(), SPECIALIZATION, this.getRoleConfigValue(roleConfig, SPECIALIZATION));
        return model;
    }
}

