/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.audit;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.knox.gateway.audit.api.CorrelationService;
import org.apache.knox.gateway.audit.log4j.audit.Log4jAuditService;
import org.apache.knox.gateway.audit.log4j.correlation.Log4jCorrelationService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;

public class Log4jAuditor
implements Auditor {
    public static final String MASKED_QUERY_PARAMS_OPTION = "masked_params";
    private Logger logger;
    private String componentName;
    private String serviceName;
    private AuditService auditService = new Log4jAuditService();
    private CorrelationService correlationService = new Log4jCorrelationService();
    private static List<String> maskedParams = new ArrayList<String>();

    public Log4jAuditor(String loggerName, String componentName, String serviceName) {
        this.logger = (Logger)LogManager.getLogger((String)loggerName);
        this.logger.setAdditive(false);
        this.componentName = componentName;
        this.serviceName = serviceName;
        String masked_query_params = System.getProperty(MASKED_QUERY_PARAMS_OPTION);
        if (masked_query_params != null) {
            String[] params;
            for (String s : params = masked_query_params.split(",")) {
                if (maskedParams.contains(s)) continue;
                maskedParams.add(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void audit(CorrelationContext correlationContext, AuditContext auditContext, String action, String resourceName, String resourceType, String outcome, String message) {
        CorrelationContext previousCorrelationContext = null;
        AuditContext previousAuditContext = null;
        try {
            previousCorrelationContext = this.correlationService.getContext();
            previousAuditContext = this.auditService.getContext();
            this.auditService.attachContext(auditContext);
            this.correlationService.attachContext(correlationContext);
            this.auditLog(action, resourceName, resourceType, outcome, message);
        }
        finally {
            if (previousAuditContext != null) {
                this.auditService.attachContext(previousAuditContext);
            }
            if (previousCorrelationContext != null) {
                this.correlationService.attachContext(previousCorrelationContext);
            }
        }
    }

    @Override
    public void audit(String action, String resourceName, String resourceType, String outcome, String message) {
        this.auditLog(action, resourceName, resourceType, outcome, message);
    }

    @Override
    public void audit(String action, String resourceName, String resourceType, String outcome) {
        this.auditLog(action, resourceName, resourceType, outcome, null);
    }

    private void auditLog(String action, String resourceName, String resourceType, String outcome, String message) {
        if (this.logger.isInfoEnabled()) {
            ThreadContext.put((String)"action", (String)action);
            ThreadContext.put((String)"resource_name", (String)Log4jAuditor.maskTokenFromURL(resourceName));
            ThreadContext.put((String)"resource_type", (String)resourceType);
            ThreadContext.put((String)"outcome", (String)outcome);
            ThreadContext.put((String)"service_name", (String)this.serviceName);
            ThreadContext.put((String)"component_name", (String)this.componentName);
            this.logger.info(message);
            ThreadContext.remove((String)"action");
            ThreadContext.remove((String)"resource_name");
            ThreadContext.remove((String)"resource_type");
            ThreadContext.remove((String)"outcome");
            ThreadContext.remove((String)"service_name");
            ThreadContext.remove((String)"component_name");
        }
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getAuditorName() {
        return this.logger.getName();
    }

    public static String maskTokenFromURL(String originalUrl) {
        try {
            URI original = new URI(originalUrl);
            if (original.getQuery() != null && !original.getQuery().isEmpty()) {
                String[] query = original.getQuery().split("&");
                StringBuilder newQuery = new StringBuilder();
                for (int i = 0; i < query.length; ++i) {
                    for (String s : maskedParams) {
                        if (query[i].contains(s + "=")) {
                            newQuery.append(s).append("=***************");
                            continue;
                        }
                        newQuery.append(query[i]);
                    }
                    if (i >= query.length - 1) continue;
                    newQuery.append('&');
                }
                URI newURI = new URI(original.getScheme(), original.getAuthority(), original.getPath(), newQuery.toString(), original.getFragment());
                return newURI.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return originalUrl;
    }

    static {
        maskedParams.add("knoxtoken");
    }
}

