/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.plang;

import java.util.List;
import org.apache.knox.gateway.plang.ArityException;

public interface Arity {
    public static final Arity UNARY = Arity.of(1);
    public static final Arity BINARY = Arity.of(2);

    public void check(String var1, List<?> var2);

    public static Arity of(int count) {
        return (methodName, params) -> {
            if (params.size() != count) {
                throw new ArityException(methodName, count, params.size());
            }
        };
    }

    public static Arity min(int count) {
        return (methodName, params) -> {
            if (params.size() < count) {
                throw new ArityException("wrong number of arguments in call to '" + methodName + "'. Expected at least " + count + " got " + params.size() + ".");
            }
        };
    }
}

