/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.cellar.core.event;

import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Node;

import java.io.Serializable;
import java.util.Set;

/**
 * This class represents an event that is broad-casted to the cluster.
 * The event is always generated by a single node (source) but can have none or multiple destinations.
 */
public class Event implements Serializable {

    protected String id;
    protected Node sourceNode;
    protected Group sourceGroup;
    protected Set<Node> destination;
    protected Boolean force = Boolean.FALSE;
    protected Boolean postPublish = Boolean.FALSE;

    public Event(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Node getSourceNode() {
        return sourceNode;
    }

    public void setSourceNode(Node sourceNode) {
        this.sourceNode = sourceNode;
    }

    public Group getSourceGroup() {
        return sourceGroup;
    }

    public void setSourceGroup(Group sourceGroup) {
        this.sourceGroup = sourceGroup;
    }

    public Set<Node> getDestination() {
        return destination;
    }

    public void setDestination(Set<Node> destination) {
        this.destination = destination;
    }

    public Boolean getForce() {
        return force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public Boolean getPostPublish() {
        return postPublish;
    }

    public void setPostPublish(Boolean postPublish) {
        this.postPublish = postPublish;
    }

}
