/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.solver.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.tdb1.solver.stats.StatsCollectorBase;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;

public class StatsCollectorNodeId
extends StatsCollectorBase<NodeId> {
    private NodeTable nodeTable;

    public StatsCollectorNodeId(NodeTable nodeTable) {
        super(StatsCollectorNodeId.findRDFType(nodeTable));
        this.nodeTable = nodeTable;
    }

    private static NodeId findRDFType(NodeTable nodeTable2) {
        return nodeTable2.getAllocateNodeId(NodeConst.nodeRDFType);
    }

    @Override
    protected Map<Node, Long> convert(Map<NodeId, Long> stats) {
        HashMap<Node, Long> statsNodes = new HashMap<Node, Long>(1000);
        for (NodeId p : stats.keySet()) {
            Node n = this.nodeTable.getNodeForNodeId(p);
            statsNodes.put(n, stats.get(p));
        }
        return statsNodes;
    }
}

